/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public class EntityInfo {
    private String tableName;
    private Class<?> entityClass;
    private Class<?> mapperClass;
    private Map<String, String> mapperSqls = new HashMap<String, String>();
    private String errorMsg;
    private Class<?> idType;
    private String idProperty;
    private String idColumn;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public EntityInfo(String mapperClassName, String entityClassName) {
        try {
            if (StringUtils.isNotBlank((CharSequence)entityClassName)) {
                this.entityClass = Class.forName(entityClassName);
            }
            if (this.entityClass.isAnnotationPresent(Table.class)) {
                Field[] fields;
                this.tableName = this.entityClass.getAnnotation(Table.class).name();
                for (Field field : fields = this.entityClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Id.class)) continue;
                    this.idType = field.getType();
                    this.idProperty = field.getName();
                    Column column = field.getAnnotation(Column.class);
                    this.idColumn = column != null && StringUtils.isNotBlank((CharSequence)column.name()) ? column.name() : this.idProperty;
                    break;
                }
            } else {
                this.errorMsg = "entityClass[" + entityClassName + "] not found annotation[@Table]";
                return;
            }
            this.mapperClass = Class.forName(mapperClassName);
            Method[] methods = this.mapperClass.getDeclaredMethods();
            String sql = null;
            for (Method method : methods) {
                sql = null;
                if (method.isAnnotationPresent(Select.class)) {
                    sql = method.getAnnotation(Select.class).value()[0];
                } else if (method.isAnnotationPresent(Update.class)) {
                    sql = method.getAnnotation(Update.class).value()[0];
                } else if (method.isAnnotationPresent(Delete.class)) {
                    sql = method.getAnnotation(Delete.class).value()[0];
                }
                if (sql == null) continue;
                String key = this.mapperClass.getName() + "." + method.getName();
                this.mapperSqls.put(key, sql);
            }
        }
        catch (ClassNotFoundException e) {
            this.errorMsg = e.getMessage();
        }
        catch (Exception e) {
            this.errorMsg = String.format("parse error,please check class[{}] and [{}]", entityClassName, mapperClassName);
        }
    }

    public EntityInfo(String mapperClassName, String entityClassName, String tableName) {
        this.tableName = tableName;
        try {
            if (StringUtils.isNotBlank((CharSequence)entityClassName)) {
                this.entityClass = Class.forName(entityClassName);
            }
            if (StringUtils.isBlank((CharSequence)this.tableName)) {
                this.tableName = this.entityClass.getAnnotation(Table.class).name();
            }
            this.mapperClass = Class.forName(mapperClassName);
        }
        catch (Exception e) {
            try {
                Type[] types = this.mapperClass.getGenericInterfaces();
                Type[] tempTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
                Class clazz = (Class)tempTypes[0];
                if (clazz != null) {
                    this.entityClass = clazz;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<?> getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(Class<?> mapperClass) {
        this.mapperClass = mapperClass;
    }

    public void addSql(String id, String sql) {
        this.mapperSqls.put(this.mapperClass.getName() + "." + id, sql);
    }

    public Map<String, String> getMapperSqls() {
        return this.mapperSqls;
    }

    public Class<?> getIdType() {
        return this.idType;
    }

    public String getIdProperty() {
        return this.idProperty;
    }

    public String getIdColumn() {
        return this.idColumn;
    }
}

