/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin;

import com.jeesuite.mybatis.core.InterceptorHandler;
import com.jeesuite.mybatis.parser.MybatisMapperParser;
import com.jeesuite.mybatis.plugin.cache.CacheHandler;
import com.jeesuite.mybatis.plugin.pagination.PaginationHandler;
import com.jeesuite.mybatis.plugin.rwseparate.RwRouteHandler;
import com.jeesuite.mybatis.plugin.shard.DatabaseRouteHandler;
import com.jeesuite.spring.InstanceFactory;
import com.jeesuite.spring.SpringInstanceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class JeesuiteMybatisInterceptor
implements Interceptor,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private Properties properties;
    private List<InterceptorHandler> interceptorHandlers = new ArrayList<InterceptorHandler>();
    private static boolean cacheEnabled;
    private static boolean rwRouteEnabled;
    private static boolean dbShardEnabled;

    public void setInterceptorHandlers(String interceptorHandlers) {
        String[] handlerNames;
        for (String name : handlerNames = StringUtils.tokenizeToStringArray((String)interceptorHandlers, (String)",; \t\n")) {
            if ("cache".equals(name)) {
                this.interceptorHandlers.add(new CacheHandler());
                cacheEnabled = true;
                continue;
            }
            if ("rwRoute".equals(name)) {
                this.interceptorHandlers.add(new RwRouteHandler());
                rwRouteEnabled = true;
                continue;
            }
            if ("dbShard".equals(name)) {
                this.interceptorHandlers.add(new DatabaseRouteHandler());
                dbShardEnabled = true;
                continue;
            }
            if (!"page".equals(name)) continue;
            this.interceptorHandlers.add(new PaginationHandler());
        }
        Collections.sort(this.interceptorHandlers, new Comparator<InterceptorHandler>(){

            @Override
            public int compare(InterceptorHandler o1, InterceptorHandler o2) {
                return Integer.compare(o1.interceptorOrder(), o2.interceptorOrder());
            }
        });
    }

    public void setMapperLocations(String mapperLocations) {
        MybatisMapperParser.setMapperLocations(mapperLocations);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        InterceptorHandler handler2;
        Object result = null;
        boolean proceed = false;
        Iterator<InterceptorHandler> iterator = this.interceptorHandlers.iterator();
        while (iterator.hasNext() && (result = (handler2 = iterator.next()).onInterceptor(invocation)) == null) {
        }
        if (result == null) {
            result = invocation.proceed();
            proceed = true;
        }
        for (InterceptorHandler handler2 : this.interceptorHandlers) {
            handler2.onFinished(invocation, proceed ? result : null);
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        for (InterceptorHandler handler : this.interceptorHandlers) {
            handler.start(this);
        }
    }

    public void destroy() throws Exception {
        for (InterceptorHandler handler : this.interceptorHandlers) {
            handler.close();
        }
    }

    public String getProperty(String key) {
        return this.properties == null ? null : this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultVal) {
        String property = this.getProperty(key);
        return property == null ? defaultVal : property;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public static boolean isRwRouteEnabled() {
        return rwRouteEnabled;
    }

    public static boolean isDbShardEnabled() {
        return dbShardEnabled;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        InstanceFactory.setInstanceProvider((SpringInstanceProvider)new SpringInstanceProvider(applicationContext));
    }
}

