/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.cache;

import com.jeesuite.mybatis.core.BaseEntity;
import com.jeesuite.mybatis.core.InterceptorHandler;
import com.jeesuite.mybatis.exception.MybatisHanlerInitException;
import com.jeesuite.mybatis.kit.CacheKeyUtils;
import com.jeesuite.mybatis.kit.ReflectUtils;
import com.jeesuite.mybatis.parser.EntityInfo;
import com.jeesuite.mybatis.parser.MybatisMapperParser;
import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import com.jeesuite.mybatis.plugin.cache.CacheMethodDefine;
import com.jeesuite.mybatis.plugin.cache.CacheProvider;
import com.jeesuite.mybatis.plugin.cache.annotation.Cache;
import com.jeesuite.mybatis.plugin.cache.annotation.CacheEvictCascade;
import com.jeesuite.mybatis.plugin.cache.name.DefaultCacheMethodDefine;
import com.jeesuite.mybatis.plugin.cache.name.Mapper3CacheMethodDefine;
import com.jeesuite.mybatis.plugin.cache.provider.DefaultCacheProvider;
import com.jeesuite.spring.InstanceFactory;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements InterceptorHandler {
    private static final String TK_MAPPER_EXAMPLE_CLASS_NAME = "tk.mybatis.mapper.entity.Example";
    protected static final Logger logger = LoggerFactory.getLogger(CacheHandler.class);
    public static final String NAME = "cache";
    private static final String PARSE_SQL_ERROR_DEFAULT = "select 'error'";
    public static final long IN_1MINS = 60L;
    public static final long IN_1HOUR = 3600L;
    public static long defaultCacheExpire = 3600L;
    private static final String STR_PARAM = "param";
    private static final String STR_LIST = "list";
    private static final String STR_COLLECTION = "collection";
    private static final String ID_CACHEKEY_JOIN = ".id:";
    private static final String WHERE_REGEX = "(w|W)(here|HERE)";
    private static final String QUERY_IDS_SUFFIX = "_ralateIds";
    protected static final String SPLIT_PONIT = ".";
    public static final String GROUPKEY_SUFFIX = "~keys";
    private boolean dynamicCacheTime = false;
    private boolean nullValueCache = false;
    public static final String NULL_PLACEHOLDER = "~null";
    private static List<String> cacheEnableMappers = new ArrayList<String>();
    private static Map<String, String> mapperNameRalateEntityNames = new HashMap<String, String>();
    private static Map<String, List<String>> cacheEvictCascades = new HashMap<String, List<String>>();
    private static Map<String, Map<String, QueryMethodCache>> queryCacheMethods = new HashMap<String, Map<String, QueryMethodCache>>();
    private static Map<String, UpdateByPkMethodCache> updateCacheMethods = new HashMap<String, UpdateByPkMethodCache>();
    private static List<String> groupKeys = new ArrayList<String>();
    private static ThreadLocal<List<String>> TransactionWriteCacheKeys = new ThreadLocal();
    protected static CacheProvider cacheProvider;
    private CacheMethodDefine methodDefine;
    private ScheduledExecutorService clearExpiredGroupKeysTimer;

    public void setCacheProvider(CacheProvider cacheProvider) {
        CacheHandler.cacheProvider = cacheProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CacheProvider getCacheProvider() {
        if (cacheProvider != null) return cacheProvider;
        Class<CacheHandler> clazz = CacheHandler.class;
        synchronized (CacheHandler.class) {
            if (cacheProvider == null) {
                cacheProvider = (CacheProvider)InstanceFactory.getInstance(CacheProvider.class);
            }
            if (cacheProvider == null) {
                cacheProvider = new DefaultCacheProvider();
            }
            logger.info("Initializing cacheProvider use:{} ", (Object)cacheProvider.getClass().getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheProvider;
        }
    }

    @Override
    public Object onInterceptor(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mt = (MappedStatement)args[0];
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            QueryMethodCache cacheInfo = this.getQueryMethodCache(mt.getId());
            if (cacheInfo == null) {
                return null;
            }
            String cacheKey = this.genarateQueryCacheKey(cacheInfo.keyPattern, args[1]);
            ArrayList<Object> cacheObject = null;
            boolean nullPlaceholder = false;
            if (!cacheInfo.isSecondQueryById()) {
                cacheObject = (ArrayList<Object>)CacheHandler.getCacheProvider().get(cacheKey);
                boolean bl = nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(cacheObject);
                if (nullPlaceholder) {
                    logger.debug("_autocache_ method[{}] find NULL_PLACEHOLDER result from cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                } else if (cacheObject != null) {
                    logger.debug("_autocache_ method[{}] find result from cacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                }
            } else {
                String refCacheKey;
                String string = refCacheKey = this.nullValueCache ? (String)CacheHandler.getCacheProvider().get(cacheKey) : CacheHandler.getCacheProvider().getStr(cacheKey);
                if (refCacheKey != null) {
                    nullPlaceholder = this.nullValueCache && NULL_PLACEHOLDER.equals(refCacheKey);
                    if (nullPlaceholder) {
                        cacheObject = NULL_PLACEHOLDER;
                    } else {
                        cacheObject = CacheHandler.getCacheProvider().get(refCacheKey);
                        if (cacheObject != null && logger.isDebugEnabled()) {
                            logger.debug("_autocache_ method[{}] find result from cacheKey:{} ,ref by:{}", new Object[]{mt.getId(), refCacheKey, cacheKey});
                        }
                    }
                }
            }
            if (nullPlaceholder) {
                cacheObject = new ArrayList();
            } else if (cacheObject != null && !(cacheObject instanceof Collection)) {
                cacheObject = new ArrayList<Object>(Arrays.asList(cacheObject));
            }
            return cacheObject;
        }
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.DELETE) && !updateCacheMethods.containsKey(mt.getId())) {
            String mapperNameSpace = mt.getId().substring(0, mt.getId().lastIndexOf(SPLIT_PONIT));
            Executor executor = (Executor)invocation.getTarget();
            this.removeCacheByUpdateConditon(executor, mt, mapperNameSpace, args);
        }
        return null;
    }

    @Override
    public void onFinished(Invocation invocation, Object result) {
        Object[] args = invocation.getArgs();
        MappedStatement mt = (MappedStatement)args[0];
        String mapperNameSpace = mt.getId().substring(0, mt.getId().lastIndexOf(SPLIT_PONIT));
        QueryMethodCache cacheInfo = null;
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            if (result == null) {
                return;
            }
            cacheInfo = this.getQueryMethodCache(mt.getId());
            if (cacheInfo == null) {
                return;
            }
            String cacheKey = this.genarateQueryCacheKey(cacheInfo.keyPattern, args[1]);
            if (result instanceof List) {
                List list = (List)result;
                if (list.isEmpty()) {
                    if (this.nullValueCache) {
                        CacheHandler.getCacheProvider().set(cacheKey, NULL_PLACEHOLDER, 60L);
                    }
                    return;
                }
                Object object = result = cacheInfo.collectionResult ? result : list.get(0);
            }
            if (!cacheInfo.isSecondQueryById()) {
                if (CacheHandler.getCacheProvider().set(cacheKey, result, cacheInfo.getExpire()) && logger.isDebugEnabled()) {
                    logger.debug("_autocache_ method[{}] put result to cache\uff0ccacheKey:{}", (Object)mt.getId(), (Object)cacheKey);
                }
                if (cacheInfo.groupRalated) {
                    CacheHandler.getCacheProvider().putGroup(cacheInfo.cacheGroupKey, cacheKey, cacheInfo.getExpire());
                    logger.debug("_autocache_ method[{}] add key:[{}] to group key:[{}]", new Object[]{mt.getId(), cacheInfo.cacheGroupKey, cacheKey});
                } else {
                    this.cacheUniqueSelectRef(result, mt, cacheKey);
                }
            } else {
                String idCacheKey = this.genarateQueryCacheKey(this.getQueryByPkMethodCache((String)mt.getId()).keyPattern, result);
                if (idCacheKey != null && cacheKey != null) {
                    if (!CacheHandler.getCacheProvider().exists(idCacheKey)) {
                        CacheHandler.getCacheProvider().set(idCacheKey, result, cacheInfo.getExpire());
                    }
                    this.cacheFieldRefKey(cacheKey, idCacheKey, cacheInfo.getExpire());
                    if (logger.isDebugEnabled()) {
                        logger.debug("_autocache_ method[{}] put result to cache\uff0ccacheKey:{},and add ref cacheKey:{}", new Object[]{mt.getId(), idCacheKey, cacheKey});
                    }
                }
            }
        } else {
            if (!cacheEnableMappers.contains(mapperNameSpace)) {
                return;
            }
            if (result != null && (Integer)result == 0) {
                return;
            }
            boolean insertAction = mt.getSqlCommandType().equals((Object)SqlCommandType.INSERT);
            boolean updateAction = mt.getSqlCommandType().equals((Object)SqlCommandType.UPDATE);
            boolean deleteAcrion = mt.getSqlCommandType().equals((Object)SqlCommandType.DELETE);
            if (updateCacheMethods.containsKey(mt.getId())) {
                String idCacheKey = null;
                UpdateByPkMethodCache updateMethodCache = updateCacheMethods.get(mt.getId());
                if (deleteAcrion) {
                    idCacheKey = this.genarateQueryCacheKey(updateMethodCache.keyPattern, args[1]);
                    CacheHandler.getCacheProvider().remove(idCacheKey);
                    if (logger.isDebugEnabled()) {
                        logger.debug("_autocache_ method[{}] remove cacheKey:{} from cache", (Object)mt.getId(), (Object)idCacheKey);
                    }
                } else {
                    idCacheKey = this.genarateQueryCacheKey(updateMethodCache.keyPattern, args[1]);
                    if ((insertAction || updateAction) && result != null) {
                        QueryMethodCache queryByPkMethodCache = this.getQueryByPkMethodCache(mt.getId());
                        CacheHandler.getCacheProvider().set(idCacheKey, args[1], queryByPkMethodCache.getExpire());
                        if (logger.isDebugEnabled()) {
                            logger.debug("_autocache_ method[{}] update cacheKey:{}", (Object)mt.getId(), (Object)idCacheKey);
                        }
                        if (insertAction) {
                            this.cacheUniqueSelectRef(args[1], mt, idCacheKey);
                        }
                        this.addCurrentThreadCacheKey(idCacheKey);
                    }
                }
            } else if (updateAction) {
                Executor executor = (Executor)invocation.getTarget();
                this.removeCacheByUpdateConditon(executor, mt, mapperNameSpace, args);
            }
            this.removeCacheByGroup(mt.getId(), mapperNameSpace, false);
        }
    }

    private void removeCacheByUpdateConditon(Executor executor, MappedStatement mt, String mapperNameSpace, Object[] args) {
        try {
            Object parameterObject = args[1];
            if (parameterObject != null && parameterObject.getClass().getName().equals(TK_MAPPER_EXAMPLE_CLASS_NAME)) {
                this.removeCacheByGroup(mt.getId(), mapperNameSpace, true);
                logger.warn("[tk.mybatis.mapper.entity.Example] Not recommended for use with [@Cache],may be caching cleanup failure", (Object)TK_MAPPER_EXAMPLE_CLASS_NAME, (Object)mapperNameSpace);
                return;
            }
            EntityInfo entityInfo = MybatisMapperParser.getEntityInfoByMapper(mapperNameSpace);
            MappedStatement statement = this.getQueryIdsMappedStatementForUpdateCache(mt, entityInfo);
            if (statement == null) {
                return;
            }
            String querySql = statement.getSqlSource().getBoundSql(parameterObject).getSql();
            List idsResult = null;
            if (PARSE_SQL_ERROR_DEFAULT.equals(querySql)) {
                BoundSql boundSql = mt.getBoundSql(parameterObject);
                querySql = "select " + entityInfo.getIdColumn() + " from " + entityInfo.getTableName() + " WHERE " + boundSql.getSql().split(WHERE_REGEX)[1];
                BoundSql queryBoundSql = new BoundSql(statement.getConfiguration(), querySql, boundSql.getParameterMappings(), parameterObject);
                idsResult = executor.query(statement, parameterObject, RowBounds.DEFAULT, (ResultHandler)new DefaultResultHandler(), null, queryBoundSql);
            } else {
                idsResult = executor.query(statement, parameterObject, RowBounds.DEFAULT, null);
            }
            if (idsResult != null && !idsResult.isEmpty()) {
                for (Object id : idsResult) {
                    String cacheKey = entityInfo.getEntityClass().getSimpleName() + ID_CACHEKEY_JOIN + id.toString();
                    CacheHandler.getCacheProvider().remove(cacheKey);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("_autocache_ update Method[{}] executed,remove ralate cache {}.id:[{}]", new Object[]{mt.getId(), entityInfo.getEntityClass().getSimpleName(), idsResult});
                }
            }
        }
        catch (Exception e) {
            this.removeCacheByGroup(mt.getId(), mapperNameSpace, true);
            logger.error("_autocache_ removecache_by_update [{}] error,force clean all group cache", (Object)mt.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedStatement getQueryIdsMappedStatementForUpdateCache(MappedStatement mt, EntityInfo entityInfo) {
        String msId = mt.getId() + QUERY_IDS_SUFFIX;
        MappedStatement statement = null;
        Configuration configuration = mt.getConfiguration();
        try {
            statement = configuration.getMappedStatement(msId);
            if (statement != null) {
                return statement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configuration configuration2 = configuration;
        synchronized (configuration2) {
            if (configuration.hasStatement(msId)) {
                return configuration.getMappedStatement(msId);
            }
            String sql = entityInfo.getMapperSqls().get(mt.getId());
            if (StringUtils.isNotBlank((CharSequence)sql)) {
                if (!sql.toLowerCase().contains(entityInfo.getTableName().toLowerCase())) {
                    return null;
                }
                sql = "select " + entityInfo.getIdColumn() + " from " + entityInfo.getTableName() + " WHERE " + sql.split(WHERE_REGEX)[1];
                sql = String.format("<script>%s</script>", sql);
            } else {
                sql = PARSE_SQL_ERROR_DEFAULT;
            }
            SqlSource sqlSource = configuration.getDefaultScriptingLanguageInstance().createSqlSource(configuration, sql, Object.class);
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, SqlCommandType.SELECT);
            statementBuilder.resource(mt.getResource());
            statementBuilder.fetchSize(mt.getFetchSize());
            statementBuilder.statementType(mt.getStatementType());
            statementBuilder.parameterMap(mt.getParameterMap());
            statement = statementBuilder.build();
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            String id = msId + "-Inline";
            ResultMap.Builder builder = new ResultMap.Builder(configuration, id, entityInfo.getIdType(), new ArrayList(), Boolean.valueOf(true));
            resultMaps.add(builder.build());
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
            configuration.addMappedStatement(statement);
            return statement;
        }
    }

    private void removeCacheByGroup(String msId, String mapperNameSpace, boolean removePkCache) {
        String entityName = mapperNameRalateEntityNames.get(mapperNameSpace);
        CacheHandler.getCacheProvider().clearGroup(entityName, removePkCache);
        logger.debug("_autocache_ method[{}] remove cache Group:{}", (Object)msId, (Object)entityName);
        if (cacheEvictCascades.containsKey(msId)) {
            for (String entity : cacheEvictCascades.get(msId)) {
                String cacheGroup = entity + GROUPKEY_SUFFIX;
                CacheHandler.getCacheProvider().clearExpiredGroupKeys(entity + GROUPKEY_SUFFIX);
                logger.debug("_autocache_ method[{}] remove Cascade cache Group:[{}]", (Object)msId, (Object)cacheGroup);
            }
        }
    }

    private void cacheUniqueSelectRef(Object object, MappedStatement mt, String cacheKey) {
        Collection<QueryMethodCache> mcs = queryCacheMethods.get(mt.getId().substring(0, mt.getId().lastIndexOf(SPLIT_PONIT))).values();
        block2: for (QueryMethodCache methodCache : mcs) {
            if (methodCache.isPk || methodCache.groupRalated) continue;
            try {
                Object[] cacheFieldValues = new Object[methodCache.fieldNames.length];
                for (int i = 0; i < cacheFieldValues.length; ++i) {
                    if (methodCache.fieldNames[i] == null) break block2;
                    cacheFieldValues[i] = ReflectUtils.getObjectValue(object, methodCache.fieldNames[i]);
                    if (cacheFieldValues[i] == null) continue block2;
                }
                String fieldCacheKey = this.genarateQueryCacheKey(methodCache.keyPattern, cacheFieldValues);
                this.cacheFieldRefKey(fieldCacheKey, cacheKey, methodCache.getExpire());
                if (!logger.isDebugEnabled()) continue;
                logger.debug("_autocache_ method[{}] add ref cacheKey:{}", (Object)mt.getId(), (Object)fieldCacheKey);
            }
            catch (Exception e) {
                logger.warn("cacheUniqueSelectRef:" + cacheKey, (Throwable)e);
            }
        }
    }

    private void cacheFieldRefKey(String fieldCacheKey, String idCacheKey, long expired) {
        if (this.nullValueCache) {
            CacheHandler.getCacheProvider().set(fieldCacheKey, idCacheKey, expired);
        } else {
            CacheHandler.getCacheProvider().setStr(fieldCacheKey, idCacheKey, expired);
        }
    }

    private String genarateQueryCacheKey(String keyPattern, Object param) {
        if (param instanceof Map) {
            Map map = (Map)param;
            Object[] args = new String[map.size() / 2];
            if (map.containsKey(STR_COLLECTION) || map.containsKey(STR_LIST)) {
                args[0] = CacheKeyUtils.toString(map.containsKey(STR_COLLECTION) ? map.get(STR_COLLECTION) : map.get(STR_LIST));
            } else {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = CacheKeyUtils.toString(map.get(STR_PARAM + (i + 1)));
                }
            }
            return String.format(keyPattern, args);
        }
        if (param instanceof BaseEntity) {
            Serializable id = ((BaseEntity)param).getId();
            if (id != null && !"0".equals(id.toString())) {
                return String.format(keyPattern, ((BaseEntity)param).getId());
            }
            return String.format(keyPattern, CacheKeyUtils.toString(param));
        }
        if (param instanceof Object[]) {
            return String.format(keyPattern, (Object[])param);
        }
        return param == null ? keyPattern : String.format(keyPattern, CacheKeyUtils.toString(param));
    }

    private QueryMethodCache getQueryMethodCache(String mtId) {
        String key1 = mtId.substring(0, mtId.lastIndexOf(SPLIT_PONIT));
        if (queryCacheMethods.containsKey(key1)) {
            return queryCacheMethods.get(key1).get(mtId);
        }
        return null;
    }

    private QueryMethodCache getQueryByPkMethodCache(String mtId) {
        if (queryCacheMethods.containsKey(mtId = mtId.substring(0, mtId.lastIndexOf(SPLIT_PONIT)))) {
            return queryCacheMethods.get(mtId).get(mtId + SPLIT_PONIT + this.methodDefine.selectName());
        }
        return null;
    }

    @Override
    public void start(JeesuiteMybatisInterceptor context) {
        this.nullValueCache = Boolean.parseBoolean(context.getProperty("cache.nullValue", "false"));
        this.dynamicCacheTime = Boolean.parseBoolean(context.getProperty("cache.dynamic.expire", "false"));
        defaultCacheExpire = Long.parseLong(context.getProperty("cache.expire.seconds", String.valueOf(3600L)));
        String crudDriver = context.getProperty("crudDriver", "default");
        this.methodDefine = "mapper3".equalsIgnoreCase(crudDriver) ? new Mapper3CacheMethodDefine() : new DefaultCacheMethodDefine();
        logger.info("crudDriver use:{},nullValueCache:{},defaultCacheExpireSeconds:{},dynamicCacheTime:{}", new Object[]{crudDriver, this.nullValueCache, defaultCacheExpire, this.dynamicCacheTime});
        List<EntityInfo> entityInfos = MybatisMapperParser.getEntityInfos();
        Class<BaseEntity> baseEntityClass = BaseEntity.class;
        QueryMethodCache methodCache = null;
        for (EntityInfo ei : entityInfos) {
            Method[] methods;
            if (!baseEntityClass.isAssignableFrom(ei.getEntityClass())) {
                logger.warn("[{}] not extends from [{}],ignore register auto cache!!!!", (Object)ei.getEntityClass().getName(), (Object)baseEntityClass.getName());
                continue;
            }
            Class<?> mapperClass = ei.getMapperClass();
            QueryMethodCache queryByPKMethod = this.generateQueryByPKMethod(mapperClass, ei.getEntityClass());
            if (queryByPKMethod == null) continue;
            boolean entityWithAnnotation = ei.getEntityClass().isAnnotationPresent(Cache.class);
            Cache annotationCache = null;
            String keyPatternForPK = queryByPKMethod.keyPattern;
            HashMap<String, QueryMethodCache> tmpMap = new HashMap<String, QueryMethodCache>();
            for (Method method : methods = mapperClass.getDeclaredMethods()) {
                CacheEvictCascade cascade;
                String fullMethodName = mapperClass.getName() + SPLIT_PONIT + method.getName();
                if (method.isAnnotationPresent(Cache.class)) {
                    annotationCache = method.getAnnotation(Cache.class);
                    if (tmpMap.containsKey(fullMethodName)) continue;
                    methodCache = this.generateQueryMethodCacheByMethod(ei, method);
                    methodCache.setExpire(annotationCache.expire());
                    tmpMap.put(fullMethodName, methodCache);
                    logger.info("\u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)methodCache.methodName, (Object)methodCache.keyPattern);
                    continue;
                }
                if (!method.isAnnotationPresent(CacheEvictCascade.class) || (cascade = method.getAnnotation(CacheEvictCascade.class)).cascadeEntities().length <= 0) continue;
                ArrayList<String> entityNames = new ArrayList<String>();
                for (Class<? extends BaseEntity> clazz : cascade.cascadeEntities()) {
                    entityNames.add(clazz.getSimpleName());
                }
                cacheEvictCascades.put(fullMethodName, entityNames);
                logger.info("\u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u5173\u8054\u66f4\u65b0\u7f13\u5b58\u914d\u7f6e ok,cascadeEntities:[{}]", (Object)fullMethodName, entityNames);
            }
            if (!entityWithAnnotation && tmpMap.isEmpty()) continue;
            QueryMethodCache selectAllMethod = this.generateSelectAllMethod(mapperClass, ei.getEntityClass());
            tmpMap.put(selectAllMethod.methodName, selectAllMethod);
            if (entityWithAnnotation) {
                queryByPKMethod.setExpire(ei.getEntityClass().getAnnotation(Cache.class).expire());
                selectAllMethod.setExpire(ei.getEntityClass().getAnnotation(Cache.class).expire());
            }
            cacheEnableMappers.add(ei.getMapperClass().getName());
            mapperNameRalateEntityNames.put(ei.getMapperClass().getName(), ei.getEntityClass().getSimpleName());
            tmpMap.put(queryByPKMethod.methodName, queryByPKMethod);
            logger.info("\u89e3\u6790\u67e5\u8be2\u65b9\u6cd5{}\u81ea\u52a8\u7f13\u5b58\u914d\u7f6e ok,keyPattern:[{}]", (Object)queryByPKMethod.methodName, (Object)queryByPKMethod.keyPattern);
            queryCacheMethods.put(mapperClass.getName(), tmpMap);
            this.generateUpdateByPkCacheMethod(mapperClass, ei.getEntityClass(), keyPatternForPK);
            groupKeys.add(queryByPKMethod.cacheGroupKey);
        }
        if (queryCacheMethods.isEmpty()) {
            return;
        }
        this.registerClearExpiredGroupKeyTask();
    }

    private void registerClearExpiredGroupKeyTask() {
        this.clearExpiredGroupKeysTimer = Executors.newScheduledThreadPool(1);
        this.clearExpiredGroupKeysTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (String key : groupKeys) {
                    try {
                        CacheHandler.getCacheProvider().clearExpiredGroupKeys(key);
                    }
                    catch (Exception e) {
                        logger.warn("_autocache_ clearExpiredGroupKeys for {} error!!", (Object)key);
                    }
                }
            }
        }, 5L, 60L, TimeUnit.MINUTES);
    }

    private QueryMethodCache generateQueryByPKMethod(Class<?> mapperClass, Class<?> entityClass) {
        Field[] fields;
        QueryMethodCache methodCache = null;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            methodCache = new QueryMethodCache();
            methodCache.isPk = true;
            methodCache.collectionResult = false;
            methodCache.keyPattern = entityClass.getSimpleName() + ".id:%s";
            methodCache.methodName = mapperClass.getName() + SPLIT_PONIT + this.methodDefine.selectName();
            methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
        }
        return methodCache;
    }

    private QueryMethodCache generateSelectAllMethod(Class<?> mapperClass, Class<?> entityClass) {
        QueryMethodCache methodCache = new QueryMethodCache();
        methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
        methodCache.methodName = mapperClass.getName() + SPLIT_PONIT + this.methodDefine.selectAllName();
        methodCache.keyPattern = entityClass.getSimpleName() + ".all";
        methodCache.isPk = false;
        methodCache.collectionResult = true;
        methodCache.groupRalated = true;
        return methodCache;
    }

    private void generateUpdateByPkCacheMethod(Class<?> mapperClass, Class<?> entityClass, String keyPatternForPK) {
        String[] updateNames;
        String[] insertNames;
        String methodName = null;
        for (String name : insertNames = this.methodDefine.insertName().split(",")) {
            methodName = mapperClass.getName() + SPLIT_PONIT + name;
            updateCacheMethods.put(methodName, new UpdateByPkMethodCache(entityClass, methodName, keyPatternForPK, SqlCommandType.INSERT));
        }
        for (String name : updateNames = this.methodDefine.updateName().split(",")) {
            methodName = mapperClass.getName() + SPLIT_PONIT + name;
            updateCacheMethods.put(methodName, new UpdateByPkMethodCache(entityClass, methodName, keyPatternForPK, SqlCommandType.UPDATE));
        }
        methodName = mapperClass.getName() + SPLIT_PONIT + this.methodDefine.deleteName();
        updateCacheMethods.put(methodName, new UpdateByPkMethodCache(entityClass, methodName, keyPatternForPK, SqlCommandType.DELETE));
    }

    private QueryMethodCache generateQueryMethodCacheByMethod(EntityInfo entityInfo, Method method) {
        String methodName;
        Class<?> mapperClass = entityInfo.getMapperClass();
        Class<?> entityClass = entityInfo.getEntityClass();
        QueryMethodCache methodCache = new QueryMethodCache();
        methodCache.methodName = methodName = mapperClass.getName() + SPLIT_PONIT + method.getName();
        methodCache.fieldNames = new String[method.getParameterTypes().length];
        methodCache.cacheGroupKey = entityClass.getSimpleName() + GROUPKEY_SUFFIX;
        boolean bl = methodCache.collectionResult = method.getReturnType() == List.class || method.getReturnType() == Set.class;
        methodCache.groupRalated = methodCache.collectionResult ? true : !method.getReturnType().isAnnotationPresent(Table.class);
        StringBuilder sb = new StringBuilder(entityClass.getSimpleName()).append(SPLIT_PONIT).append(method.getName());
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] aa = annotations[i];
            if (aa.length > 0) {
                String fieldName = null;
                for (Annotation annotation : aa) {
                    if (!annotation.toString().contains(Param.class.getName())) continue;
                    fieldName = ((Param)annotation).value();
                    break;
                }
                if (!methodCache.groupRalated && MybatisMapperParser.entityHasProperty(entityClass, fieldName)) {
                    methodCache.fieldNames[i] = fieldName;
                }
            } else if (!methodCache.groupRalated) {
                throw new MybatisHanlerInitException(String.format("unique\u67e5\u8be2\u65b9\u6cd5[%s] \u4f7f\u7528\u4e86\u81ea\u52a8\u7f13\u5b58Annotation @Cache,\u53c2\u6570\u5fc5\u987b\u4f7f\u7528 @Param \u7ed1\u5b9a\u5c5e\u6027\u540d\u79f0", methodName));
            }
            sb.append(i == 0 ? ":" : "_").append("%s");
        }
        if (!methodCache.groupRalated && methodCache.fieldNames.length == 1 && entityInfo.getIdProperty().equals(methodCache.fieldNames[0])) {
            throw new MybatisHanlerInitException(String.format("\u6309\u4e3b\u952e\u67e5\u8be2\u65b9\u6cd5[%s] \u4f7f\u7528\u4e86\u81ea\u52a8\u7f13\u5b58Annotation @Cache,\u8bf7\u4f7f\u7528\u9ed8\u8ba4\u65b9\u6cd5[%s]\u4ee3\u66ff", methodName, this.methodDefine.selectName()));
        }
        methodCache.keyPattern = sb.toString();
        return methodCache;
    }

    private void addCurrentThreadCacheKey(String key) {
        List<String> keys = TransactionWriteCacheKeys.get();
        if (keys == null) {
            keys = new ArrayList<String>();
            TransactionWriteCacheKeys.set(keys);
        }
        keys.add(key);
    }

    public static void rollbackCache() {
        List<String> keys = TransactionWriteCacheKeys.get();
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            CacheHandler.getCacheProvider().remove(key);
        }
    }

    @Override
    public void close() {
        try {
            CacheHandler.getCacheProvider().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clearExpiredGroupKeysTimer.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int interceptorOrder() {
        return 0;
    }

    private class UpdateByPkMethodCache {
        public String keyPattern;

        public UpdateByPkMethodCache(Class<?> entityClass, String methodName, String keyPattern, SqlCommandType sqlCommandType) {
            this.keyPattern = keyPattern;
        }
    }

    private class QueryMethodCache {
        public String cacheGroupKey;
        public String methodName;
        public String keyPattern;
        public long expire;
        public boolean isPk = false;
        public boolean collectionResult = false;
        public boolean groupRalated = false;
        public String[] fieldNames;

        public void setExpire(long expire) {
            this.expire = expire > 0L ? expire : defaultCacheExpire;
        }

        public long getExpire() {
            if (!CacheHandler.this.dynamicCacheTime) {
                return this.expire;
            }
            long rnd = RandomUtils.nextLong((long)0L, (long)3600L);
            return this.expire + (rnd > this.expire ? RandomUtils.nextLong((long)0L, (long)this.expire) : rnd);
        }

        public boolean isSecondQueryById() {
            return !this.isPk && !this.groupRalated;
        }
    }
}

