/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.cache;

import com.jeesuite.cache.command.RedisObject;
import com.jeesuite.mybatis.core.BaseEntity;
import com.jeesuite.mybatis.plugin.cache.CacheHandler;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class EntityCacheHelper {
    public static <T extends BaseEntity> void addCache(T bean, int expireSeconds) {
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        new RedisObject(key).set(bean, (long)expireSeconds);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, Callable<T> dataCaller) {
        return EntityCacheHelper.queryTryCache(entityClass, key, CacheHandler.defaultCacheExpire, dataCaller);
    }

    public static <T> T queryTryCache(Class<? extends BaseEntity> entityClass, String key, long expireSeconds, Callable<T> dataCaller) {
        if (CacheHandler.cacheProvider == null) {
            try {
                return dataCaller.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        Object result = CacheHandler.cacheProvider.get(key);
        if (result == null) {
            try {
                result = dataCaller.call();
                if (result != null) {
                    CacheHandler.cacheProvider.set(key, result, expireSeconds);
                    String cacheGroupKey = entityClassName + "~keys";
                    CacheHandler.cacheProvider.putGroup(cacheGroupKey, key, expireSeconds);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass, String key) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String entityClassName = entityClass.getSimpleName();
        key = entityClassName + "." + key;
        String cacheGroupKey = entityClassName + "~keys";
        CacheHandler.cacheProvider.remove(key);
        CacheHandler.cacheProvider.removeFromGroup(cacheGroupKey, key);
    }

    public static <T extends BaseEntity> void removeCache(T bean) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String key = EntityCacheHelper.buildCacheKey(bean.getClass(), bean.getId());
        CacheHandler.cacheProvider.remove(key);
    }

    public static void removeCache(Class<? extends BaseEntity> entityClass) {
        if (CacheHandler.cacheProvider == null) {
            return;
        }
        String entityClassName = entityClass.getSimpleName();
        CacheHandler.cacheProvider.clearGroup(entityClassName, true);
    }

    public static String buildCacheKey(Class<?> entityClass, Serializable id) {
        return entityClass.getSimpleName() + ".id:" + id;
    }
}

