/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.cache.provider;

import com.jeesuite.cache.command.RedisBatchCommand;
import com.jeesuite.cache.command.RedisObject;
import com.jeesuite.cache.command.RedisString;
import com.jeesuite.cache.redis.JedisProviderFactory;
import com.jeesuite.mybatis.plugin.cache.provider.AbstractCacheProvider;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCommands;

public class DefaultCacheProvider
extends AbstractCacheProvider {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCacheProvider.class);

    @Override
    public <T> T get(String key) {
        return (T)new RedisObject(key).get();
    }

    @Override
    public String getStr(String key) {
        return new RedisString(key).get();
    }

    @Override
    public boolean set(String key, Object value, long expireSeconds) {
        if (value == null) {
            return false;
        }
        return new RedisObject(key).set(value, expireSeconds);
    }

    @Override
    public boolean setStr(String key, Object value, long expireSeconds) {
        if (value == null) {
            return false;
        }
        return new RedisString(key).set(value.toString(), expireSeconds);
    }

    @Override
    public boolean remove(String key) {
        return new RedisObject(key).remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putGroup(String cacheGroupKey, String key, long expireSeconds) {
        long score = this.calcScoreInRegionKeysSet(expireSeconds);
        JedisCommands commands = JedisProviderFactory.getJedisCommands(null);
        try {
            commands.zadd(cacheGroupKey, (double)score, key);
            commands.pexpire(cacheGroupKey, expireSeconds * 1000L);
        }
        finally {
            JedisProviderFactory.getJedisProvider(null).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromGroup(String cacheGroupKey, String key) {
        JedisCommands commands = JedisProviderFactory.getJedisCommands(null);
        try {
            commands.zrem(cacheGroupKey, new String[]{key});
            commands.del(key);
        }
        finally {
            JedisProviderFactory.getJedisProvider(null).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearGroup(String groupName, boolean containPkCache) {
        String cacheGroupKey = groupName + "~keys";
        JedisCommands commands = JedisProviderFactory.getJedisCommands(null);
        try {
            Set keys = commands.zrange(cacheGroupKey, 0L, -1L);
            if (keys != null && keys.size() > 0) {
                RedisBatchCommand.removeObjects((String[])keys.toArray(new String[0]));
            }
            commands.del(cacheGroupKey);
            if (containPkCache && (keys = JedisProviderFactory.getMultiKeyCommands(null).keys(groupName + ".id:*")) != null && keys.size() > 0) {
                RedisBatchCommand.removeObjects((String[])keys.toArray(new String[0]));
            }
        }
        finally {
            JedisProviderFactory.getJedisProvider(null).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearExpiredGroupKeys(String cacheGroup) {
        long maxScore = System.currentTimeMillis() / 1000L - this.baseScoreInRegionKeysSet;
        JedisCommands commands = JedisProviderFactory.getJedisCommands(null);
        try {
            commands.zremrangeByScore(cacheGroup, 0.0, (double)maxScore);
        }
        finally {
            JedisProviderFactory.getJedisProvider(null).release();
        }
        logger.debug("clearExpiredGroupKeys runing:cacheName:{} , score range:0~{}", (Object)cacheGroup, (Object)maxScore);
    }

    @Override
    public boolean exists(String key) {
        return new RedisObject(key).exists();
    }

    @Override
    public void close() throws IOException {
    }
}

