/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.cache.provider;

import com.jeesuite.mybatis.plugin.cache.provider.AbstractCacheProvider;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public class SpringRedisProvider
extends AbstractCacheProvider
implements InitializingBean {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private RedisSerializer keySerializer;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.keySerializer = redisTemplate.getKeySerializer();
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public <T> T get(String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public String getStr(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public boolean set(String key, Object value, long expireSeconds) {
        if (value == null) {
            return false;
        }
        this.redisTemplate.opsForValue().set((Object)key, value, expireSeconds, TimeUnit.SECONDS);
        return true;
    }

    @Override
    public boolean setStr(String key, Object value, long expireSeconds) {
        if (value == null) {
            return false;
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value.toString(), expireSeconds, TimeUnit.SECONDS);
        return true;
    }

    @Override
    public boolean remove(String key) {
        this.redisTemplate.delete((Object)key);
        return true;
    }

    @Override
    public void putGroup(String cacheGroupKey, String key, long expireSeconds) {
        long score = this.calcScoreInRegionKeysSet(expireSeconds);
        this.stringRedisTemplate.opsForZSet().add((Object)cacheGroupKey, (Object)key, (double)score);
    }

    @Override
    public void removeFromGroup(String cacheGroupKey, String key) {
        this.stringRedisTemplate.opsForZSet().remove((Object)cacheGroupKey, new Object[]{key});
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void clearGroup(final String groupName, final boolean containPkCache) {
        final String cacheGroupKey = groupName + "~keys";
        Set keys = this.stringRedisTemplate.opsForZSet().range((Object)cacheGroupKey, 0L, -1L);
        if (keys.isEmpty()) {
            return;
        }
        final Object[] keysToArray = keys.toArray(new String[0]);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Void>(){

            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                String idKeyPattern;
                Set idKeys;
                byte[][] keyArray = new byte[keysToArray.length][];
                for (int i = 0; i < keyArray.length; ++i) {
                    keyArray[i] = SpringRedisProvider.this.keySerializer.serialize(keysToArray[i]);
                }
                connection.del((byte[][])keyArray);
                AbstractCacheProvider.logger.debug("cascade remove cache keyPattern:{},size:{}", (Object)cacheGroupKey, (Object)keysToArray.length);
                if (containPkCache && (idKeys = connection.keys((idKeyPattern = groupName + ".id:*").getBytes())).size() > 0) {
                    connection.del((byte[][])idKeys.toArray((T[])new byte[0][0]));
                    AbstractCacheProvider.logger.debug("cascade remove cache keyPattern:{},size:{}", (Object)idKeyPattern, (Object)idKeys.size());
                }
                return null;
            }
        });
        this.stringRedisTemplate.opsForZSet().remove((Object)cacheGroupKey, keysToArray);
    }

    @Override
    public void clearExpiredGroupKeys(String cacheGroup) {
        long maxScore = System.currentTimeMillis() / 1000L - this.baseScoreInRegionKeysSet;
        this.stringRedisTemplate.opsForZSet().removeRangeByScore((Object)cacheGroup, 0.0, (double)maxScore);
        logger.debug("ClearExpiredRegionKeysTimer runing:cacheName:{} , score range:0~{}", (Object)cacheGroup, (Object)maxScore);
    }

    @Override
    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.stringRedisTemplate, (String)" [stringRedisTemplate] is required", (Object[])new Object[0]);
        Validate.notNull(this.redisTemplate, (String)" [redisTemplate] is required", (Object[])new Object[0]);
    }
}

