/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.pagination;

import com.jeesuite.mybatis.plugin.pagination.Page;
import com.jeesuite.mybatis.plugin.pagination.PageParams;
import java.util.List;

public class PageExecutor {
    private static ThreadLocal<PageParams> pageParamsHolder = new ThreadLocal();

    public static <T> Page<T> pagination(PageParams pageParams, PageDataLoader<T> dataLoader) {
        pageParamsHolder.set(pageParams);
        List<T> list = dataLoader.load();
        return (Page)list.get(0);
    }

    public static PageParams getPageParams() {
        return pageParamsHolder.get();
    }

    public static void clearPageParams() {
        pageParamsHolder.remove();
    }

    public static interface PageDataLoader<T> {
        public List<T> load();
    }
}

