/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.pagination;

import com.jeesuite.mybatis.plugin.pagination.PageParams;

public class PageSqlUtils {
    private static final String REGEX_N_T_S = "\\n+|\\t+\\s{2,}";
    private static final String PAGE_SIZE_PLACEHOLDER = "#{pageSize}";
    private static final String OFFSET_PLACEHOLDER = "#{offset}";
    private static final String SQL_SELECT_PATTERN = "(select|SELECT).*?(?=from|FROM)";
    private static final String SQL_ORDER_PATTERN = "(order|ORDER)\\s+(by|BY)";
    private static final String SQL_COUNT_PREFIX = "SELECT count(1) ";

    public static String getLimitSQL(DbType dbType, String sql) {
        return String.format(dbType.getTemplate(), sql);
    }

    public static String getLimitSQL(DbType dbType, String sql, PageParams pageParams) {
        return PageSqlUtils.getLimitSQL(dbType, sql).replace(OFFSET_PLACEHOLDER, String.valueOf(pageParams.offset())).replace(PAGE_SIZE_PLACEHOLDER, String.valueOf(pageParams.getPageSize())).replaceAll(REGEX_N_T_S, " ");
    }

    public static String getCountSql(String sql) {
        sql = sql.replaceAll(REGEX_N_T_S, " ").split(SQL_ORDER_PATTERN)[0];
        return sql.replaceFirst(SQL_SELECT_PATTERN, SQL_COUNT_PREFIX);
    }

    public static void main(String[] args) {
        String sql = "select a.* from audited_policy a where 1=1 \n\t   \n\t   \n\t   \n\t   \n\t   and title like CONCAT('%',?,'%')   \n\t   \n\t   \n\t   \n\t   \n\t   \n\t   \n\t    \n\t   \n\t  order by updated_at desc";
        System.out.println(">>>>" + PageSqlUtils.getCountSql(sql));
        System.out.println(">>>>" + PageSqlUtils.getLimitSQL(DbType.MYSQL, sql, new PageParams()));
        System.out.println("------------");
        sql = "select a.* from audited_policy a where 1=1 \n and EXISTS (select 1 from policy_tag tag where tag.id in (select tag_id from policy_r_tag rtag where rtag.policy_id= a.id) and tag.name like CONCAT('%',?,'%') ) order by updated_at desc";
        System.out.println(">>>>" + PageSqlUtils.getCountSql(sql));
        System.out.println(">>>>" + PageSqlUtils.getLimitSQL(DbType.MYSQL, sql, new PageParams()));
        sql = "SELECT  u.id as userId,u.name,u.cert_no as idcard,u.mobile,u.verified as userVerified,u.cert_front_url certFrontUrl,u.cert_back_url certBackUrl,  o.salary,o.notax as afterTaxSalary,o.vattax as vatax,o.extratax as surtax,o.incometax,o.tax,o.invfphm as invoiceNo  FROM cbd_invorderdet";
        System.out.println(sql.replaceAll(SQL_SELECT_PATTERN, SQL_COUNT_PREFIX));
    }

    public static enum DbType {
        MYSQL("%s limit #{offset},#{pageSize}"),
        ORACLE("select * from (select a1.*,rownum rn from (%s) a1 where rownum <=#{offset} + #{pageSize}) where rn>=#{offset}"),
        H2("%s limit #{pageSize} offset #{offset}"),
        POSTGRESQL("%s limit #{pageSize} offset #{offset}");

        private final String template;

        private DbType(String template) {
            this.template = template;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

