/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.pagination;

import com.jeesuite.mybatis.core.InterceptorHandler;
import com.jeesuite.mybatis.exception.MybatisHanlerInitException;
import com.jeesuite.mybatis.parser.EntityInfo;
import com.jeesuite.mybatis.parser.MybatisMapperParser;
import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import com.jeesuite.mybatis.plugin.pagination.Page;
import com.jeesuite.mybatis.plugin.pagination.PageExecutor;
import com.jeesuite.mybatis.plugin.pagination.PageParams;
import com.jeesuite.mybatis.plugin.pagination.PageSqlUtils;
import com.jeesuite.mybatis.plugin.pagination.annotation.Pageable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationHandler
implements InterceptorHandler {
    private static Logger logger = LoggerFactory.getLogger(PaginationHandler.class);
    public static final String NAME = "page";
    private static final String PARAMETER_SIZE = "pageSize";
    private static final String PARAMETER_OFFSET = "offset";
    private static final String PAGE_LIMIT_SUFFIX = "_PageLimit";
    private static final String PAGE_COUNT_SUFFIX = "_PageCount";
    private Map<String, Boolean> pageMappedStatements = new HashMap<String, Boolean>();
    private List<String> createdPageMappedStatements = new ArrayList<String>();
    private PageSqlUtils.DbType dbType = PageSqlUtils.DbType.MYSQL;

    public void setDbType(String dbType) {
        PageSqlUtils.DbType[] dbTypes;
        if (StringUtils.isBlank((CharSequence)dbType)) {
            return;
        }
        for (PageSqlUtils.DbType dt : dbTypes = PageSqlUtils.DbType.values()) {
            if (!dt.name().equalsIgnoreCase(dbType)) continue;
            this.dbType = dt;
            break;
        }
    }

    @Override
    public void start(JeesuiteMybatisInterceptor context) {
        this.setDbType(context.getProperty("dbType"));
        logger.info("dbType:{}", (Object)this.dbType.name());
        List<EntityInfo> entityInfos = MybatisMapperParser.getEntityInfos();
        for (EntityInfo ei : entityInfos) {
            Method[] methods;
            Class<?> mapperClass = ei.getMapperClass();
            for (Method method : methods = mapperClass.getDeclaredMethods()) {
                String msId;
                if (method.getReturnType() == Page.class) {
                    Class<?> clazz;
                    Class<?>[] parameterTypes;
                    msId = ei.getMapperClass().getName() + "." + method.getName();
                    boolean withPageParams = false;
                    Class<?>[] classArray = parameterTypes = method.getParameterTypes();
                    int n = classArray.length;
                    for (int i = 0; i < n && !(withPageParams = (clazz = classArray[i]) == PageParams.class || clazz.getSuperclass() == PageParams.class); ++i) {
                    }
                    if (!withPageParams) {
                        throw new MybatisHanlerInitException(String.format("method[%s] returnType is:Page,but not found Parameter[PageParams] in Parameters list", method.getName()));
                    }
                    this.pageMappedStatements.put(msId, true);
                    continue;
                }
                if (!method.isAnnotationPresent(Pageable.class)) continue;
                msId = ei.getMapperClass().getName() + "." + method.getName();
                this.pageMappedStatements.put(msId, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object onInterceptor(Invocation invocation) throws Throwable {
        try {
            List datas;
            Collection parameterValues;
            Executor executor = (Executor)invocation.getTarget();
            Object[] args = invocation.getArgs();
            MappedStatement orignMappedStatement = (MappedStatement)args[0];
            if (!orignMappedStatement.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
                Object var5_5 = null;
                return var5_5;
            }
            PageParams pageParams = PageExecutor.getPageParams();
            if (pageParams == null && !this.pageMappedStatements.keySet().contains(orignMappedStatement.getId())) {
                Object var6_7 = null;
                return var6_7;
            }
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            Object parameter = args[1];
            BoundSql boundSql = args.length == 4 ? orignMappedStatement.getBoundSql(parameter) : (BoundSql)args[5];
            if (pageParams == null && this.pageMappedStatements.get(orignMappedStatement.getId()).booleanValue()) {
                if (parameter instanceof Map) {
                    parameterValues = ((Map)parameter).values();
                    for (Object val : parameterValues) {
                        if (!(val instanceof PageParams)) continue;
                        pageParams = (PageParams)val;
                        break;
                    }
                } else {
                    pageParams = (PageParams)parameter;
                }
            }
            if (pageParams == null) {
                parameterValues = null;
                return parameterValues;
            }
            MappedStatement countMappedStatement = this.getCountMappedStatement(orignMappedStatement);
            Long total = this.executeQueryCount(executor, countMappedStatement, parameter, boundSql, rowBounds, resultHandler);
            MappedStatement limitMappedStatement = this.getLimitMappedStatementIfNotCreate(orignMappedStatement);
            if (limitMappedStatement == null) {
                if (StringUtils.isBlank((CharSequence)boundSql.getSql())) {
                    logger.error("create_limit_mappedStatement_error\u3002MappedStatementId:{},pageParamsHolder:{}", (Object)orignMappedStatement.getId(), (Object)PageExecutor.getPageParams());
                    throw new RuntimeException("\u751f\u6210Limit\u67e5\u8be2\u8bed\u53e5\u9519\u8bef");
                }
                String pageSql = PageSqlUtils.getLimitSQL(this.dbType, boundSql.getSql(), pageParams);
                BoundSql pageBoundSql = new BoundSql(orignMappedStatement.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
                datas = executor.query(orignMappedStatement, parameter, RowBounds.DEFAULT, resultHandler, null, pageBoundSql);
            } else {
                BoundSql pageBoundSql = limitMappedStatement.getBoundSql(parameter);
                pageBoundSql.setAdditionalParameter(PARAMETER_OFFSET, (Object)pageParams.offset());
                pageBoundSql.setAdditionalParameter(PARAMETER_SIZE, (Object)pageParams.getPageSize());
                datas = executor.query(limitMappedStatement, parameter, RowBounds.DEFAULT, resultHandler, null, pageBoundSql);
            }
            Page page = new Page(pageParams, total, datas);
            ArrayList list = new ArrayList(1);
            list.add(page);
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            PageExecutor.clearPageParams();
        }
    }

    private Long executeQueryCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, RowBounds rowBounds, ResultHandler resultHandler) throws IllegalAccessException, SQLException {
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        String orignSql = StringUtils.replace((String)boundSql.getSql(), (String)";$", (String)"");
        String countSql = PageSqlUtils.getCountSql(orignSql);
        BoundSql countBoundSql = new BoundSql(countMs.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
        Long count = (Long)countResultList.get(0);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedStatement getCountMappedStatement(MappedStatement ms) {
        String newMsId = ms.getId() + PAGE_COUNT_SUFFIX;
        MappedStatement statement = null;
        Configuration configuration = ms.getConfiguration();
        try {
            statement = configuration.getMappedStatement(newMsId);
            if (statement != null) {
                return statement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configuration configuration2 = configuration;
        synchronized (configuration2) {
            if (configuration.hasStatement(newMsId)) {
                return configuration.getMappedStatement(newMsId);
            }
            MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), newMsId, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.keyGenerator(ms.getKeyGenerator());
            if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
                StringBuilder keyProperties = new StringBuilder();
                for (String keyProperty : ms.getKeyProperties()) {
                    keyProperties.append(keyProperty).append(",");
                }
                keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
                builder.keyProperty(keyProperties.toString());
            }
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            String id = newMsId + "-Inline";
            ResultMap resultMap = new ResultMap.Builder(configuration, id, Long.class, new ArrayList(0)).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            builder.useCache(ms.isUseCache());
            statement = builder.build();
            configuration.addMappedStatement(statement);
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedStatement getLimitMappedStatementIfNotCreate(MappedStatement orignMappedStmt) {
        String msId = orignMappedStmt.getId() + PAGE_LIMIT_SUFFIX;
        MappedStatement statement = null;
        Configuration configuration = orignMappedStmt.getConfiguration();
        try {
            statement = configuration.getMappedStatement(msId);
            if (statement != null) {
                return statement;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.createdPageMappedStatements.contains(orignMappedStmt.getId())) {
                return null;
            }
            EntityInfo entityInfo = MybatisMapperParser.getEntityInfoByMapper(orignMappedStmt.getId().substring(0, orignMappedStmt.getId().lastIndexOf(".")));
            String orignSql = entityInfo.getMapperSqls().get(orignMappedStmt.getId());
            if (StringUtils.isBlank((CharSequence)orignSql)) {
                logger.error("create_limit_mappedStatement_error\u3002MappedStatementId:{},entityClass:{},pageParamsHolder:{}", new Object[]{orignMappedStmt.getId(), entityInfo.getEntityClass().getName(), PageExecutor.getPageParams()});
                throw new RuntimeException("\u751f\u6210Limit\u67e5\u8be2\u8bed\u53e5\u9519\u8bef");
            }
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                this.createdPageMappedStatements.add(orignMappedStmt.getId());
                if (configuration.hasStatement(msId)) {
                    return configuration.getMappedStatement(msId);
                }
                String sql = PageSqlUtils.getLimitSQL(this.dbType, orignSql);
                sql = String.format("<script>%s</script>", sql);
                SqlSource sqlSource = configuration.getDefaultScriptingLanguageInstance().createSqlSource(configuration, sql, Object.class);
                MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, msId, sqlSource, SqlCommandType.SELECT);
                statementBuilder.resource(orignMappedStmt.getResource());
                statementBuilder.statementType(orignMappedStmt.getStatementType());
                statementBuilder.parameterMap(orignMappedStmt.getParameterMap());
                statementBuilder.resultSetType(orignMappedStmt.getResultSetType());
                statementBuilder.resultMaps(orignMappedStmt.getResultMaps());
                statement = statementBuilder.build();
                configuration.addMappedStatement(statement);
                return statement;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void onFinished(Invocation invocation, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 9;
    }
}

