/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.rwseparate;

import com.jeesuite.mybatis.core.InterceptorHandler;
import com.jeesuite.mybatis.datasource.DataSourceContextHolder;
import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RwRouteHandler
implements InterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger(RwRouteHandler.class);
    public static final String NAME = "rwRoute";

    @Override
    public Object onInterceptor(Invocation invocation) throws Throwable {
        Object[] objects = invocation.getArgs();
        MappedStatement ms = (MappedStatement)objects[0];
        if (DataSourceContextHolder.get().isForceUseMaster()) {
            logger.debug("Method[{}] force use Master..", (Object)ms.getId());
            return null;
        }
        if (ms.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            if (!ms.getId().contains("!selectKey")) {
                DataSourceContextHolder.get().useSlave(true);
                logger.debug("Method[{} use Slave Strategy..", (Object)ms.getId());
            }
        } else {
            logger.debug("Method[{}] use Master Strategy..", (Object)ms.getId());
            DataSourceContextHolder.get().useSlave(false);
        }
        return null;
    }

    @Override
    public void onFinished(Invocation invocation, Object result) {
    }

    @Override
    public void start(JeesuiteMybatisInterceptor context) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

