/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.plugin.shard;

import com.jeesuite.mybatis.core.InterceptorHandler;
import com.jeesuite.mybatis.datasource.DataSourceContextHolder;
import com.jeesuite.mybatis.kit.ReflectUtils;
import com.jeesuite.mybatis.parser.EntityInfo;
import com.jeesuite.mybatis.parser.MybatisMapperParser;
import com.jeesuite.mybatis.plugin.JeesuiteMybatisInterceptor;
import com.jeesuite.mybatis.plugin.shard.ShardStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRouteHandler
implements InterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DatabaseRouteHandler.class);
    public static final String NAME = "dbShard";
    private static final String SPIT_POINT = ".";
    private static final String REGEX_BLANK = "\\n+\\s+";
    private ShardStrategy<?> shardStrategy;
    private Pattern shardFieldAfterWherePattern;
    private List<String> ignoreTablesMapperNameSpace = new ArrayList<String>();
    private List<String> ignoreMappedStatementIds = new ArrayList<String>();
    private Map<String, String> shardFieldRalateParamNames = new HashMap<String, String>();

    public void setShardStrategy(ShardStrategy<?> shardStrategy) {
        this.shardStrategy = shardStrategy;
    }

    @Override
    public Object onInterceptor(Invocation invocation) throws Throwable {
        Object[] objects = invocation.getArgs();
        MappedStatement ms = (MappedStatement)objects[0];
        Object parameterObject = objects[1];
        if (this.ignoreMappedStatementIds.contains(ms.getId())) {
            return null;
        }
        String namespace = ms.getId().substring(0, ms.getId().lastIndexOf(SPIT_POINT));
        if (this.ignoreTablesMapperNameSpace.contains(namespace)) {
            return null;
        }
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        Object parameterObject2 = boundSql.getParameterObject();
        System.out.println(parameterObject2);
        boolean requiredShard = this.isRequiredShard(boundSql.getSql(), ms.getSqlCommandType(), namespace);
        if (requiredShard) {
            Object shardFieldValue = this.getShardFieldValue(ms.getId(), parameterObject);
            if (shardFieldValue == null) {
                logger.error("\u65b9\u6cd5{}\u65e0\u6cd5\u83b7\u53d6\u5206\u5e93\u5b57\u6bb5{}\u7684\u503c", (Object)ms.getId(), (Object)this.shardStrategy.shardEntityField());
            } else {
                int dbIndex = this.shardStrategy.assigned(shardFieldValue);
                DataSourceContextHolder.get().setDbIndex(dbIndex);
            }
        }
        return null;
    }

    @Override
    public void onFinished(Invocation invocation, Object result) {
    }

    private boolean isRequiredShard(String sql, SqlCommandType cmdType, String namespace) {
        boolean isRequired = MybatisMapperParser.tableHasColumn(namespace, this.shardStrategy.shardDbField());
        if (!isRequired && SqlCommandType.SELECT.equals((Object)cmdType)) {
            sql = sql.replaceAll(REGEX_BLANK, "").toLowerCase();
            isRequired = this.shardFieldAfterWherePattern.matcher(sql).matches();
        }
        return isRequired;
    }

    private Object getShardFieldValue(String mappedStatementId, Object parameterObject) {
        try {
            if (parameterObject == null || DatabaseRouteHandler.isSimpleDataType(parameterObject)) {
                return null;
            }
            if (parameterObject instanceof Map) {
                Map map = (Map)parameterObject;
                String paramsName = this.shardFieldRalateParamNames.containsKey(mappedStatementId) ? this.shardFieldRalateParamNames.get(mappedStatementId) : this.shardStrategy.shardEntityField();
                return map.get(paramsName);
            }
            return ReflectUtils.getObjectValue(parameterObject, this.shardStrategy.shardEntityField());
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5206\u5e93\u5b57\u6bb5[" + this.shardStrategy.shardEntityField() + "]\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String sql = "SELECT * FROM devices where a=2 and device_id = ?";
        System.out.println(sql.matches("^.*[WHERE|where|and|AND]\\s+device_id.*$"));
        sql = "( id,device_id,device_sn,device_type,device_name,create_time )";
        System.out.println(sql.matches("^.*,\\s*device_id\\s*,.*$"));
    }

    @Override
    public void start(JeesuiteMybatisInterceptor context) {
        List<EntityInfo> entityInfos = MybatisMapperParser.getEntityInfos();
        for (EntityInfo iterator : entityInfos) {
        }
        this.shardFieldAfterWherePattern = Pattern.compile("^.*[WHERE|where|and|AND|ON|on]\\s+.*" + this.shardStrategy.shardDbField().toLowerCase() + ".*$");
        if (this.shardStrategy.ignoreTables() != null) {
            ArrayList<String> ignoreTablesTmp = new ArrayList<String>();
            for (String table : this.shardStrategy.ignoreTables()) {
                ignoreTablesTmp.add(table.toLowerCase());
            }
            for (EntityInfo entityInfo : entityInfos) {
                if (!ignoreTablesTmp.contains(entityInfo.getTableName().toLowerCase())) continue;
                this.ignoreTablesMapperNameSpace.add(entityInfo.getMapperClass().getName());
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            Map<String, String> mapperSqls = entityInfo.getMapperSqls();
            for (String id : mapperSqls.keySet()) {
                String sql = mapperSqls.get(id).replaceAll(REGEX_BLANK, "").replaceAll("(<\\!\\[CDATA\\[)|(\\]\\]>)", "");
                if (!this.shardFieldAfterWherePattern.matcher(sql).matches()) continue;
                String[] split = sql.split("[WHERE|where|and|AND|ON|on]\\s+.*" + this.shardStrategy.shardDbField().toLowerCase());
                String paramName = split[split.length - 1].trim().replaceAll("=|#|\\s+|\\{|\\}|<|>", "").split(REGEX_BLANK)[0];
                this.shardFieldRalateParamNames.put(id, paramName.trim());
            }
        }
    }

    private static boolean isSimpleDataType(Object o) {
        Class<?> clazz = o.getClass();
        return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class) || clazz.isPrimitive();
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 2;
    }
}

