/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.mybatis.spring;

import com.jeesuite.mybatis.datasource.DataSourceContextHolder;
import com.jeesuite.mybatis.plugin.cache.CacheHandler;
import com.jeesuite.mybatis.plugin.rwseparate.UseMaster;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.transaction.annotation.Transactional;

public abstract class MybatisPluginBaseSpringInterceptor {
    public abstract void pointcut();

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        try {
            MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
            Method method = methodSignature.getMethod();
            if (method.isAnnotationPresent(UseMaster.class) || method.isAnnotationPresent(Transactional.class)) {
                DataSourceContextHolder.get().forceMaster();
            }
            Object object = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            CacheHandler.rollbackCache();
            throw e;
        }
        finally {
            DataSourceContextHolder.get().clear();
        }
    }
}

