/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.common.base.Preconditions;

public final class Trigger
extends AbstractValueModel {
    private static final Boolean COMMIT = Boolean.TRUE;
    private static final Boolean FLUSH = Boolean.FALSE;
    private static final Boolean NEUTRAL = null;
    private Boolean value = NEUTRAL;

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object newValue) {
        Preconditions.checkArgument((newValue == null || newValue instanceof Boolean ? 1 : 0) != 0, (String)"Trigger values must be of type Boolean.");
        Boolean oldValue = this.value;
        this.value = (Boolean)newValue;
        this.fireValueChange(oldValue, newValue);
    }

    public void triggerCommit() {
        if (COMMIT.equals(this.getValue())) {
            this.setValue(NEUTRAL);
        }
        this.setValue(COMMIT);
    }

    public void triggerFlush() {
        if (FLUSH.equals(this.getValue())) {
            this.setValue(NEUTRAL);
        }
        this.setValue(FLUSH);
    }
}

