package com.jidesoft.icons;

/**
 * <code>IconSet</code> is a class which works with JIDE Icon Set (<a href="http://www.jidesoft.com/icon/">http://www.jidesoft.com/icon/</a>).
 * It defines 141 icons in 12 sections in this class. We could add more in the future. All JIDE icon set will follow the
 * naming conversion as defined here.
 *
 * @see com.jidesoft.icons.IconSetManager
 */
public class IconSet {
    public static class File {
        public final static String NEW = "File-New.png";
        public final static String OPEN = "File-Open.png";
        public final static String SAVE = "File-Save.png";
        public final static String SAVE_AS = "File-SaveAs.png";
        public final static String SAVE_ALL = "File-SaveAll.png";
        public final static String IMPORT = "File-Import.png";
        public final static String EXPORT = "File-Export.png";
        public final static String PRINT = "File-Print.png";
        public final static String PRINT_PREVIEW = "File-PrintPreview.png";
        public final static String PAGE_SETUP = "File-PageSetup.png";
        public final static String PROPERTY = "File-Property.png";
        public final static String EXIT = "File-Exit.png";
        public final static String CLOSE = "File-Close.png";
    }

    public static class Edit {
        public final static String CUT = "Edit-Cut.png";
        public final static String COPY = "Edit-Copy.png";
        public final static String PASTE = "Edit-Paste.png";
        public final static String DELETE = "Edit-Delete.png";
        public final static String UNDO = "Edit-Undo.png";
        public final static String REDO = "Edit-Redo.png";
        public final static String REFRESH = "Edit-Refresh.png";
        public final static String HISTORY = "Edit-History.png";
    }

    public static class FindReplace {
        public final static String FIND = "FindReplace-Find.png";
        public final static String FIND_AGAIN = "FindReplace-FindAgain.png";
        public final static String FIND_NEXT = "FindReplace-FindNext.png";
        public final static String FIND_PREVIOUS = "FindReplace-FindPrevious.png";
        public final static String REPLACE = "FindReplace-Replace.png";
    }

    public static class Text {
        public final static String ALIGN_CENTER = "Text-AlignCenter.png";
        public final static String ALIGN_RIGHT = "Text-AlignRight.png";
        public final static String ALIGH_LEFT = "Text-AlighLeft.png";
        public final static String JUSTIFIED = "Text-Justified.png";
        public final static String BOLD = "Text-Bold.png";
        public final static String ITALIC = "Text-Italic.png";
        public final static String UNDERLINED = "Text-Underlined.png";
        public final static String SUPERSCRIPT = "Text-Superscript.png";
        public final static String SUBSCRIPT = "Text-Subscript.png";
        public final static String STRIKETHROUGH = "Text-Strikethrough.png";
    }

    public static class View {
        public final static String ZOOM = "View-Zoom.png";
        public final static String ZOOM_IN = "View-ZoomIn.png";
        public final static String ZOOM_OUT = "View-ZoomOut.png";
        public final static String FIT_SIZE = "View-FitSize.png";
        public final static String ACTUAL_SIZE = "View-ActualSize.png";
        public final static String VIEW_FULL_SCREEN = "View-ViewFullScreen.png";
        public final static String LEAVE_FULL_SCREEN = "View-LeaveFullScreen.png";
        public final static String SORT_ASCENDING = "View-SortAscending.png";
        public final static String SORT_DESCENDING = "View-SortDescending.png";
        public final static String TREE_EXPAND = "View-TreeExpand.png";
        public final static String TREE_COLLAPSE = "View-TreeCollapse.png";
        public final static String TREE_EXPAND_ALL = "View-TreeExpandAll.png";
        public final static String TREE_COLLAPSE_ALL = "View-TreeCollapseAll.png";
        public final static String EXPAND = "View-Expand.png";
        public final static String COLLAPSE = "View-Collapse.png";
        public final static String TILT_HORIZONTALLY = "View-TiltHorizontally.png";
        public final static String TILT_VERTICALLY = "View-TiltVertically.png";
        public final static String CASCADE_WINDOW = "View-CascadeWindow.png";
    }

    public static class Help {
        public final static String HELP = "Help-Help.png";
        public final static String CONTENT = "Help-Content.png";
        public final static String INDEX = "Help-Index.png";
    }

    public static class Overlay {
        public final static String ADD = "Overlay-Add.png";
        public final static String REMOVE = "Overlay-Remove.png";
        public final static String DELETE = "Overlay-Delete.png";
        public final static String NEW = "Overlay-New.png";
        public final static String DIRTY = "Overlay-Dirty.png";
        public final static String WARNING = "Overlay-Warning.png";
        public final static String ERROR = "Overlay-Error.png";
        public final static String VALID = "Overlay-Valid.png";
        public final static String INFO = "Overlay-Info.png";
        public final static String QUESTION = "Overlay-Question.png";
        public final static String LOCK = "Overlay-Lock.png";
        public final static String UNLOCK = "Overlay-Unlock.png";
        public final static String FLAG = "Overlay-Flag.png";
        public final static String SHARE = "Overlay-Share.png";
        public final static String EDIT = "Overlay-Edit.png";
    }

    public static class Software {
        public final static String FILE = "Software-File.png";
        public final static String DOCUMENT = "Software-Document.png";
        public final static String DATABASE = "Software-Database.png";
        public final static String INTERNET = "Software-Internet.png";
        public final static String TEXT = "Software-Text.png";
        public final static String HOME = "Software-Home.png";
        public final static String TRASH = "Software-Trash.png";
        public final static String TRASH_FULL = "Software-TrashFull.png";
        public final static String USER = "Software-User.png";
        public final static String BOOKMARK = "Software-Bookmark.png";
        public final static String FOLDER = "Software-Folder.png";
        public final static String PICTURE = "Software-Picture.png";
        public final static String FRAME = "Software-Frame.png";
        public final static String MAIL = "Software-Mail.png";
        public final static String APPLICATION = "Software-Application.png";
        public final static String REPORT = "Software-Report.png";
        public final static String CHART = "Software-Chart.png";
        public final static String CALENDAR = "Software-Calendar.png";
    }

    public static class Hardware {
        public final static String NETWORK = "Hardware-Network.png";
        public final static String COMPUTER = "Hardware-Computer.png";
        public final static String SERVER = "Hardware-Server.png";
        public final static String HARD_DRIVE = "Hardware-HardDrive.png";
        public final static String MONITOR = "Hardware-Monitor.png";
        public final static String FLOPPY = "Hardware-Floppy.png";
        public final static String MOUSE = "Hardware-Mouse.png";
        public final static String KEYBOARD = "Hardware-Keyboard.png";
        public final static String CLOCK = "Hardware-Clock.png";
        public final static String CALCULATOR = "Hardware-Calculator.png";
        public final static String CAMERA = "Hardware-Camera.png";
        public final static String PRINTER = "Hardware-Printer.png";
        public final static String SCANNER = "Hardware-Scanner.png";
        public final static String PHONE = "Hardware-Phone.png";
        public final static String SPEAKER = "Hardware-Speaker.png";
        public final static String CD = "Hardware-CD.png";
        public final static String GAME_CONTROLLER = "Hardware-GameController.png";
        public final static String PDA = "Hardware-PDA.png";
    }

    public static class Direction {
        public final static String LEFT = "Direction-Left.png";
        public final static String RIGHT = "Direction-Right.png";
        public final static String UP = "Direction-Up.png";
        public final static String DOWN = "Direction-Down.png";
        public final static String TOP = "Direction-Top.png";
        public final static String BOTTOM = "Direction-Bottom.png";
        public final static String FIRST = "Direction-First.png";
        public final static String LAST = "Direction-Last.png";
        public final static String BOTTOM_LEFT = "Direction-BottomLeft.png";
        public final static String BOTTOM_RIGHT = "Direction-BottomRight.png";
        public final static String TOP_LEFT = "Direction-TopLeft.png";
        public final static String TOP_RIGHT = "Direction-TopRight.png";
    }

    public static class MediaControl {
        public final static String BEGINNING = "MediaControl-Beginning.png";
        public final static String END = "MediaControl-End.png";
        public final static String FAST_FORWARD = "MediaControl-FastForward.png";
        public final static String PASUE = "MediaControl-Pasue.png";
        public final static String PLAY = "MediaControl-Play.png";
        public final static String REWIND = "MediaControl-Rewind.png";
        public final static String STEP_BACK = "MediaControl-StepBack.png";
        public final static String STEP_FORWARD = "MediaControl-StepForward.png";
        public final static String STOP = "MediaControl-Stop.png";
        public final static String RECORD = "MediaControl-Record.png";
        public final static String EJECT = "MediaControl-Eject.png";
        public final static String SHUTDOWN = "MediaControl-Shutdown.png";
        public final static String STANDBY = "MediaControl-Standby.png";
    }

    public static class Movement {
        public final static String MOVE_LEFT = "Movement-MoveLeft.png";
        public final static String MOVE_RIGHT = "Movement-MoveRight.png";
        public final static String MOVE_UP = "Movement-MoveUp.png";
        public final static String MOVE_DOWN = "Movement-MoveDown.png";
        public final static String MOVE_TO_TOP = "Movement-MoveToTop.png";
        public final static String MOVE_TO_BOTTOM = "Movement-MoveToBottom.png";
        public final static String MOVE_TO_BEGINNING = "Movement-MoveToBeginning.png";
        public final static String MOVE_TO_END = "Movement-MoveToEnd.png";
    }

    private String _iconSetName;
    private int[] _availableSizes;
    private String _packageName;

    /**
     * Creates an IconSet.
     *
     * @param iconSetName    the icon set name
     * @param availableSizes all available sizes. It must be in order from the smallest to the biggest.
     * @param packageName    the package name where the icons exist. All icons in JIDE icon set are defined under
     *                       "com.jidesoft.icons.<iconSetName>". Then under this package, there are subfolders for each
     *                       icon size.
     */
    public IconSet(String iconSetName, int[] availableSizes, String packageName) {
        _iconSetName = iconSetName;
        _availableSizes = availableSizes;
        _packageName = packageName;
    }

    /**
     * Gets the icon set name.
     *
     * @return the icon set name.
     */
    public String getIconSetName() {
        return _iconSetName;
    }

    /**
     * Gets the next available size of the requested size. If the size is available in the icon set, it will be
     * returned. Otherwise, the next size that is bigger than the requested size will be returned. For example, if there
     * are 16, 24, 32, 48, 64 size available. If the requested size is 12, 16 will be returned. If 24 is requested, 24
     * will be returned. If 60 is requested, 64 will be returned. If 128 is requested and it is not available, so 64
     * will be returned.
     *
     * @param size the requested size
     * @return the next available size.
     */
    public int getNextAvailableSize(int size) {
        int[] sizes = getAvailableSizes();
        int nextSize = sizes[sizes.length - 1];
        for (int i : sizes) {
            if (i == size) {
                return i;
            }
            if (i > size && i < nextSize) {
                nextSize = i;
            }
        }
        return nextSize;
    }

    /**
     * Gets all the available sizes.
     *
     * @return all the available sizes.
     */
    public int[] getAvailableSizes() {
        return _availableSizes;
    }

    /**
     * Gets the package name.
     *
     * @return the package name.
     */
    public String getPackageName() {
        return _packageName;
    }

//    public static void main(String[] args) {
//        IconSet set = new IconSet("xp", new int[]{16,24,32,48,64}, "com.jidesoft.icons.xp");
//        for (int i = 0; i < 100; i++) {
//            System.out.println(i + " => " + set.getNextAvailableSize(i));
//        }
//    }
}
