/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.LazyInitializeConverter;
import jidefx.utils.converter.ObjectConverterManager;

public class EnumConverter<T>
extends DefaultObjectConverter<T>
implements LazyInitializeConverter {
    private static final String PROPERTY_ENUM_TYPE = "EnumType";
    private String _name;
    private T _default;
    private Class<?> _type;
    private Object[] _objects;
    private String[] _strings;
    private transient ConverterContext _context;

    public EnumConverter() {
    }

    public EnumConverter(Class<? extends Enum> enumType) {
        this.initializeEnums(enumType);
    }

    public EnumConverter(String name, T[] values, String[] strings) {
        this(name, values[0].getClass(), values, strings);
    }

    public EnumConverter(String name, Class<?> type, T[] values, String[] strings) {
        this(name, type, values, strings, values[0]);
    }

    public EnumConverter(String name, Class<?> type, T[] values, String[] strings, T defaultValue) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this._name = name;
        if (values == null) {
            throw new IllegalArgumentException("The \"values\" parameter cannot be null.");
        }
        if (strings == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (strings.length != values.length) {
            throw new IllegalArgumentException("The \"values\" and \"strings\" parameters should have the same length.");
        }
        this._type = type;
        this._objects = values;
        this._strings = strings;
        this._default = defaultValue;
    }

    @Override
    public void initialize(Class<?> clazz, ConverterContext converterContext) {
        if (Enum.class.isAssignableFrom(clazz)) {
            this.initializeEnums(clazz);
        }
    }

    private void initializeEnums(Class<? extends Enum> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            throw new IllegalArgumentException("To use this constructor, the type has to be an enum type.");
        }
        String name = enumType.getName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Empty enum type name.");
        }
        int index = name.lastIndexOf(36);
        this._name = index >= 0 ? name.substring(index + 1) : name;
        this._type = enumType;
        try {
            Enum[] values = enumType.getEnumConstants();
            int length = values.length;
            this._objects = new Object[length];
            this._strings = new String[length];
            for (int i = 0; i < length; ++i) {
                this._objects[i] = values[i];
                this._strings[i] = values[i].toString();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal enum type.");
        }
    }

    public ConverterContext getConverterContext() {
        if (this._context == null) {
            this._context = new ConverterContext(this._name);
        }
        return this._context;
    }

    @Override
    public String toString(T value, ConverterContext context) {
        if (value == null) {
            return "";
        }
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] == null || !this._objects[i].equals(value) || i >= this._strings.length) continue;
            return this._strings[i];
        }
        return "";
    }

    @Override
    public T fromString(String string, ConverterContext context) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        Object enumType = context.getProperties().get((Object)PROPERTY_ENUM_TYPE);
        if (this._type == null && enumType instanceof Class && Enum.class.isAssignableFrom((Class)enumType)) {
            this.initializeEnums((Class)enumType);
        }
        for (int i = 0; i < this._strings.length; ++i) {
            if (!this._strings[i].equals(string) || i >= this._objects.length) continue;
            return (T)this._objects[i];
        }
        return this._default;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public T getDefault() {
        return this._default;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public String[] getStrings() {
        return this._strings;
    }

    public static String[] toStrings(Object[] values) {
        return EnumConverter.toStrings(values, null);
    }

    public static String[] toStrings(Object[] values, ConverterContext converterContext) {
        String[] s = new String[values.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ObjectConverterManager.getInstance().toString(values[i], values[i].getClass(), converterContext);
        }
        return s;
    }
}

