/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.ValuesConverter;

public class BoundingBoxConverter
extends ValuesConverter<BoundingBox, Double> {
    public BoundingBoxConverter() {
        super("; ", Double.class);
    }

    public BoundingBoxConverter(String separator) {
        super(separator, Double.class);
    }

    public BoundingBoxConverter(String separator, Class<?> elementClass) {
        super(separator, elementClass);
    }

    @Override
    public String toString(BoundingBox boundingBox, ConverterContext context) {
        if (boundingBox == null) {
            return null;
        }
        ArrayList<Double> list = new ArrayList<Double>(6);
        list.add(boundingBox.getMinX());
        list.add(boundingBox.getMinY());
        list.add(boundingBox.getMinZ());
        list.add(boundingBox.getWidth());
        list.add(boundingBox.getHeight());
        list.add(boundingBox.getDepth());
        return this.valuesToString(list, context);
    }

    @Override
    public BoundingBox fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        List objects = this.valuesFromString(string, context);
        double minX = 0.0;
        if (objects.size() >= 1) {
            minX = (Double)objects.get(0);
        }
        double minY = 0.0;
        if (objects.size() >= 2) {
            minY = (Double)objects.get(1);
        }
        double minZ = 0.0;
        if (objects.size() >= 3) {
            minZ = (Double)objects.get(2);
        }
        double width = 0.0;
        if (objects.size() >= 4) {
            width = (Double)objects.get(3);
        }
        double height = 0.0;
        if (objects.size() >= 5) {
            height = (Double)objects.get(4);
        }
        double depth = 0.0;
        if (objects.size() >= 6) {
            depth = (Double)objects.get(5);
        }
        return new BoundingBox(minX, minY, minZ, width, height, depth);
    }
}

