/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import javafx.scene.paint.Color;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.javafx.ColorConverter;

public class HexColorConverter
extends DefaultObjectConverter<Color>
implements ColorConverter {
    private boolean _opacityIncluded = false;

    public HexColorConverter() {
    }

    public HexColorConverter(boolean opacityIncluded) {
        this._opacityIncluded = opacityIncluded;
    }

    public boolean isOpacityIncluded() {
        return this._opacityIncluded;
    }

    public void setOpacityIncluded(boolean opacityIncluded) {
        this._opacityIncluded = opacityIncluded;
    }

    private static String getHexString(int color) {
        String value = Integer.toHexString(color).toUpperCase();
        if (value.length() == 1) {
            value = '0' + value;
        }
        return value;
    }

    @Override
    public String toString(Color color, ConverterContext context) {
        if (color == null) {
            return null;
        }
        StringBuffer colorText = new StringBuffer("#");
        colorText.append(HexColorConverter.getHexString((int)Math.round(color.getRed() * 255.0)));
        colorText.append(HexColorConverter.getHexString((int)Math.round(color.getGreen() * 255.0)));
        colorText.append(HexColorConverter.getHexString((int)Math.round(color.getBlue() * 255.0)));
        if (this.isOpacityIncluded()) {
            colorText.append(HexColorConverter.getHexString((int)Math.round(color.getOpacity() * 255.0)));
        }
        return new String(colorText);
    }

    @Override
    public Color fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (this.isOpacityIncluded()) {
            if (string.length() > 8) {
                string = string.substring(string.length() - 8);
            }
        } else if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        return Color.web((String)string);
    }
}

