/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter.javafx;

import java.util.StringTokenizer;
import javafx.scene.paint.Color;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.javafx.ColorConverter;

public class RgbColorConverter
extends DefaultObjectConverter<Color>
implements ColorConverter {
    private boolean _opacityIncluded = false;

    public RgbColorConverter() {
    }

    public RgbColorConverter(boolean opacityIncluded) {
        this._opacityIncluded = opacityIncluded;
    }

    public boolean isOpacityIncluded() {
        return this._opacityIncluded;
    }

    public void setOpacityIncluded(boolean opacityIncluded) {
        this._opacityIncluded = opacityIncluded;
    }

    @Override
    public String toString(Color color, ConverterContext context) {
        if (color == null) {
            return null;
        }
        StringBuffer colorText = new StringBuffer();
        colorText.append((int)Math.round(color.getRed() * 255.0)).append(", ");
        colorText.append((int)Math.round(color.getGreen() * 255.0)).append(", ");
        colorText.append((int)Math.round(color.getBlue() * 255.0));
        if (this.isOpacityIncluded()) {
            colorText.append(", ").append((int)Math.round(color.getOpacity() * 255.0));
        }
        return new String(colorText);
    }

    @Override
    public Color fromString(String string, ConverterContext context) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(string, ",; ");
        int r = 0;
        if (token.hasMoreTokens()) {
            String s = token.nextToken();
            try {
                r = Integer.parseInt(s, 10) % 256;
                if (r < 0) {
                    r += 256;
                }
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        int g = 0;
        if (token.hasMoreTokens()) {
            String s = token.nextToken();
            try {
                g = Integer.parseInt(s, 10) % 256;
                if (g < 0) {
                    g += 256;
                }
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        int b = 0;
        if (token.hasMoreTokens()) {
            String s = token.nextToken();
            try {
                b = Integer.parseInt(s, 10) % 256;
                if (b < 0) {
                    b += 256;
                }
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        int a = 255;
        if (this.isOpacityIncluded() && token.hasMoreTokens()) {
            String s = token.nextToken();
            try {
                a = Integer.parseInt(s, 10) % 256;
                if (a < 0) {
                    a += 256;
                }
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
    }
}

