/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import jidefx.scene.control.decoration.DecorationSupport;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.MutableDecorator;
import jidefx.utils.FXUtils;

public class DecorationDelegate {
    private Region _parent;
    private ObservableMap<Node, DecorationPair> _appliedDecorationsMap;
    private Map<Node, Insets> _appliedDecorationsPadding;
    private boolean _isPaddingApplied;
    private InvalidationListener _invalidationListener;
    private HashMap<Decorator, Node> _currentDecorators;
    private List<Node> _currentTargetNodes;

    public DecorationDelegate(Region parent) {
        parent.getStylesheets().add((Object)DecorationDelegate.class.getResource("Decoration.css").toExternalForm());
        this._parent = parent;
        this._appliedDecorationsMap = FXCollections.observableHashMap();
        this._appliedDecorationsPadding = new HashMap<Node, Insets>();
        this._isPaddingApplied = false;
        MapChangeListener<Node, DecorationPair> mapChangeListener = new MapChangeListener<Node, DecorationPair>(){

            public void onChanged(MapChangeListener.Change change) {
                Node decorateNode = (Node)change.getKey();
                if (change.wasAdded()) {
                    try {
                        decorateNode.setManaged(false);
                        ((DecorationSupport)DecorationDelegate.this._parent).getChildren().add((Object)decorateNode);
                        DecorationDelegate.this._isPaddingApplied = false;
                    }
                    catch (Exception exception) {}
                } else if (change.wasRemoved()) {
                    ((DecorationSupport)DecorationDelegate.this._parent).getChildren().remove((Object)decorateNode);
                    DecorationDelegate.this._isPaddingApplied = false;
                }
            }
        };
        this._appliedDecorationsMap.addListener((MapChangeListener)mapChangeListener);
        this._invalidationListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                DecorationDelegate.this._parent.requestLayout();
            }
        };
    }

    public void prepareDecorations() {
        Node targetNode;
        if (DecorationUtils.isTargetDecoratorCleaned(this._parent)) {
            for (Node node : this._appliedDecorationsMap.keySet()) {
                if (((DecorationSupport)this._parent).getChildren().contains((Object)node)) continue;
                ((DecorationSupport)this._parent).getChildren().add((Object)node);
            }
        }
        this._currentTargetNodes = new ArrayList<Node>();
        this._currentDecorators = new HashMap();
        FXUtils.setRecursively((Object)this._parent, (FXUtils.Handler)new FXUtils.ConditionHandler<Node>(){

            public boolean condition(Node c) {
                return DecorationUtils.hasDecorators(c);
            }

            public void action(Node c) {
                Object object = DecorationUtils.getDecorators(c);
                if (object instanceof Decorator) {
                    DecorationDelegate.this._currentDecorators.put((Decorator)object, c);
                } else if (object instanceof Decorator[]) {
                    for (Decorator decorator : (Decorator[])object) {
                        DecorationDelegate.this._currentDecorators.put(decorator, c);
                    }
                }
                if (!DecorationDelegate.this._currentTargetNodes.contains(c)) {
                    DecorationDelegate.this._currentTargetNodes.add(c);
                }
            }

            public boolean stopCondition(Node c) {
                return c instanceof DecorationSupport && !c.equals(DecorationDelegate.this._parent);
            }
        });
        for (Decorator decorator : this._currentDecorators.keySet()) {
            targetNode = this._currentDecorators.get(decorator);
            Object decorateNode = this.findDecoration(targetNode, decorator);
            if (decorateNode != null || (decorateNode = decorator.getNode()) == null) continue;
            this.addDecorator(targetNode, decorator, (Node)decorateNode);
        }
        for (int i = ((DecorationSupport)this._parent).getChildren().size() - 1; i >= 0; --i) {
            Decorator decorator;
            Node decorateNode = (Node)((DecorationSupport)this._parent).getChildren().get(i);
            if (decorateNode.equals(this._parent) || this._appliedDecorationsMap.get((Object)decorateNode) == null || this._currentDecorators.containsKey(((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._decorator)) continue;
            ((DecorationSupport)this._parent).getChildren().remove(i);
            targetNode = ((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._targetNode;
            if (!this._currentTargetNodes.contains(targetNode)) {
                this._currentTargetNodes.add(targetNode);
            }
            if ((decorator = ((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._decorator) instanceof MutableDecorator) {
                this.clearPropertyChangeListeners((MutableDecorator)decorator);
            }
            this._appliedDecorationsMap.remove((Object)decorateNode);
            this._appliedDecorationsPadding.remove(decorateNode);
        }
        for (Node decorateNode : this._appliedDecorationsMap.keySet()) {
            Decorator decorator;
            if (this._appliedDecorationsMap.get((Object)decorateNode) == null || !((decorator = ((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._decorator) instanceof MutableDecorator)) continue;
            this.clearPropertyChangeListeners((MutableDecorator)decorator);
            this.registerPropertyChangeListeners((MutableDecorator)decorator);
        }
    }

    private void registerPropertyChangeListeners(MutableDecorator<?> decorator) {
        decorator.posProperty().addListener(this._invalidationListener);
        decorator.offsetProperty().addListener(this._invalidationListener);
        decorator.paddingProperty().addListener(this._invalidationListener);
        decorator.transitionProperty().addListener(this._invalidationListener);
        decorator.valueInPercentProperty().addListener(this._invalidationListener);
    }

    private void clearPropertyChangeListeners(MutableDecorator<?> decorator) {
        decorator.posProperty().removeListener(this._invalidationListener);
        decorator.offsetProperty().removeListener(this._invalidationListener);
        decorator.paddingProperty().removeListener(this._invalidationListener);
        decorator.transitionProperty().removeListener(this._invalidationListener);
        decorator.valueInPercentProperty().removeListener(this._invalidationListener);
    }

    public void layoutDecorations() {
        this.applyDecoration();
    }

    protected boolean addDecorator(Node targetNode, Decorator decorator, Node decoration) {
        return targetNode != null && decorator != null && this._appliedDecorationsMap.put((Object)decoration, (Object)new DecorationPair(targetNode, decorator)) != null;
    }

    private void applyDecoration() {
        for (Decorator decorator : this._currentDecorators.keySet()) {
            this.updateDecorationPadding(this._currentDecorators.get(decorator), decorator);
        }
        if (!this._isPaddingApplied) {
            HashMap<Node, Insets> _appliedSumPadding = new HashMap<Node, Insets>();
            for (Node targetNode : this._currentTargetNodes) {
                Insets sum = new Insets(0.0);
                if (_appliedSumPadding.get(targetNode) != null) {
                    sum = (Insets)_appliedSumPadding.get(targetNode);
                } else if (targetNode instanceof Region) {
                    Insets raw = DecorationUtils.getTargetPadding((Region)targetNode);
                    sum = new Insets(sum.getTop() + raw.getTop(), sum.getRight() + raw.getRight(), sum.getBottom() + raw.getBottom(), sum.getLeft() + raw.getLeft());
                }
                Object object = DecorationUtils.getDecorators(targetNode);
                if (object instanceof Decorator) {
                    Decorator decorator = (Decorator)object;
                    Insets padding = this._appliedDecorationsPadding.get(decorator.getNode());
                    if (padding != null) {
                        sum = new Insets(sum.getTop() + padding.getTop(), sum.getRight() + padding.getRight(), sum.getBottom() + padding.getBottom(), sum.getLeft() + padding.getLeft());
                    }
                } else if (object instanceof Decorator[]) {
                    for (Decorator decorator : (Decorator[])object) {
                        Insets padding = this._appliedDecorationsPadding.get(decorator.getNode());
                        if (padding == null) continue;
                        sum = new Insets(sum.getTop() + padding.getTop(), sum.getRight() + padding.getRight(), sum.getBottom() + padding.getBottom(), sum.getLeft() + padding.getLeft());
                    }
                }
                _appliedSumPadding.put(targetNode, sum);
                if (!(targetNode instanceof Region)) continue;
                String paddingStyle = "-fx-padding: " + sum.getTop() + " " + sum.getRight() + " " + sum.getBottom() + " " + sum.getLeft() + ";";
                String newStyle = targetNode.getStyle().replaceAll("-fx-padding:.*;", "") + paddingStyle;
                if (newStyle.equals(targetNode.getStyle())) continue;
                targetNode.setStyle(newStyle);
            }
            this._isPaddingApplied = true;
        }
        for (Node decorateNode : this._appliedDecorationsMap.keySet()) {
            Node targetNode;
            targetNode = ((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._targetNode;
            if (targetNode.getScene() == null) continue;
            Decorator decorator = ((DecorationPair)this._appliedDecorationsMap.get((Object)decorateNode))._decorator;
            Bounds bounds = DecorationUtils.computeDecorationBounds((Node)this._parent, targetNode, decorateNode, decorator);
            decorateNode.resize(bounds.getWidth(), bounds.getHeight());
            ((DecorationSupport)this._parent).positionInArea(decorateNode, bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
            decorateNode.setVisible(true);
            if (decorator.getTransition() == null || DecorationUtils.isAnimationPlayed(decorateNode)) continue;
            decorator.getTransition().play();
            DecorationUtils.setAnimationPlayed(decorateNode, true);
        }
    }

    private Node findDecoration(Node targetNode, Decorator decorator) {
        Set decorations = this._appliedDecorationsMap.keySet();
        for (Node decoration : decorations) {
            DecorationPair pair = (DecorationPair)this._appliedDecorationsMap.get((Object)decoration);
            if (pair._decorator != decorator || pair._targetNode != targetNode) continue;
            return decoration;
        }
        return null;
    }

    private void updateDecorationPadding(Node targetNode, Decorator decorator) {
        Insets newPadding = decorator.getPadding();
        Insets oldPadding = this._appliedDecorationsPadding.get(decorator.getNode());
        if (newPadding == null) {
            newPadding = DecorationUtils.computePadding((Region)targetNode, decorator);
            this._appliedDecorationsPadding.put((Node)decorator.getNode(), newPadding);
            this._isPaddingApplied = false;
        } else {
            if (decorator.isValueInPercent()) {
                double width = decorator.getNode().prefWidth(-1.0);
                double height = decorator.getNode().prefHeight(-1.0);
                newPadding = new Insets(newPadding.getTop() * height / 100.0, newPadding.getRight() * width / 100.0, newPadding.getBottom() * height / 100.0, newPadding.getLeft() * width / 100.0);
            }
            if (oldPadding == null || !newPadding.equals((Object)oldPadding)) {
                this._appliedDecorationsPadding.put((Node)decorator.getNode(), newPadding);
                this._isPaddingApplied = false;
            }
        }
    }

    class DecorationPair {
        Node _targetNode;
        Decorator _decorator;

        public DecorationPair(Node targetNode, Decorator decorator) {
            this._targetNode = targetNode;
            this._decorator = decorator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecorationPair that = (DecorationPair)o;
            if (this._decorator != null ? !this._decorator.equals(that._decorator) : that._decorator != null) {
                return false;
            }
            return !(this._targetNode != null ? !this._targetNode.equals(that._targetNode) : that._targetNode != null);
        }

        public int hashCode() {
            int result = this._targetNode != null ? this._targetNode.hashCode() : 0;
            result = 31 * result + (this._decorator != null ? this._decorator.hashCode() : 0);
            return result;
        }
    }
}

