/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import jidefx.animation.AnimationType;
import jidefx.animation.AnimationUtils;
import jidefx.scene.control.decoration.Decorator;

public class MutableDecorator<T extends Node>
extends Decorator<T> {
    public MutableDecorator() {
    }

    public MutableDecorator(T node) {
        this(node, Pos.TOP_RIGHT);
    }

    public MutableDecorator(T node, Pos pos) {
        this(node, pos, new Point2D(0.0, 0.0));
    }

    public MutableDecorator(T node, Pos pos, Point2D offset) {
        this(node, pos, offset, null);
    }

    public MutableDecorator(T node, Pos pos, Point2D offset, Insets padding) {
        this(node, pos, offset, padding, true);
    }

    public MutableDecorator(T node, Pos pos, Point2D offset, Insets padding, boolean valueInPercentOrPixels) {
        this(node, pos, offset, padding, valueInPercentOrPixels, AnimationType.NONE);
    }

    public MutableDecorator(T node, Pos pos, Point2D offset, Insets padding, boolean valueInPercentOrPixels, AnimationType type) {
        this(node, pos, offset, padding, valueInPercentOrPixels, AnimationUtils.createTransition(node, (AnimationType)type));
    }

    public MutableDecorator(T node, Pos pos, Point2D offset, Insets padding, boolean valueInPercentOrPixels, Transition transition) {
        super(node, pos, offset, padding, valueInPercentOrPixels, transition);
    }

    @Override
    public ObjectProperty<T> nodeProperty() {
        return this.nodePropertyImpl();
    }

    public ObjectProperty<Pos> posProperty() {
        return this.posPropertyImpl();
    }

    public ObjectProperty<Insets> paddingProperty() {
        return this.paddingPropertyImpl();
    }

    public ObjectProperty<Point2D> offsetProperty() {
        return this.offsetPropertyImpl();
    }

    public ObjectProperty<Transition> transitionProperty() {
        return this.transitionPropertyImpl();
    }

    public BooleanProperty valueInPercentProperty() {
        return this.valueInPercentPropertyImpl();
    }

    public void setPos(Pos pos) {
        this.posPropertyImpl().set((Object)pos);
    }

    public void setPosOffset(Point2D offset) {
        this.offsetPropertyImpl().set((Object)offset);
    }

    public void setPadding(Insets padding) {
        this.paddingPropertyImpl().set((Object)padding);
    }

    public void setTransition(Transition transition) {
        this.transitionPropertyImpl().set((Object)transition);
    }

    public void setValueInPercent(boolean valueInPercent) {
        this.valueInPercentPropertyImpl().set(valueInPercent);
    }
}

