/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.verifier.tostring.error;

import com.jparams.verifier.tostring.error.VerificationError;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ErrorMessageGenerator {
    private static final String MESSAGE_SPLITTER = "\n\n";
    private static final String ERROR_PREFIX = "   ";

    private ErrorMessageGenerator() {
    }

    public static String generateErrorMessage(Class<?> clazz, String stringValue, List<VerificationError> errors) {
        StringBuilder builder = new StringBuilder("Failed verification:\n").append(clazz.getName()).append(MESSAGE_SPLITTER).append("Expected auto generated toString:\n").append(stringValue).append(MESSAGE_SPLITTER).append("To");
        List messages = errors.stream().map(VerificationError::getMessages).flatMap(Collection::stream).collect(Collectors.toList());
        if (messages.size() == 1) {
            return builder.append(" ").append((String)messages.get(0)).toString();
        }
        builder.append(":\n");
        for (int i = 0; i < messages.size(); ++i) {
            builder.append(ERROR_PREFIX).append("- ").append(((String)messages.get(i)).replaceAll("\n", "\n   "));
            if (i >= messages.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }
}

