/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.verifier.tostring.error;

import com.jparams.verifier.tostring.error.FieldValue;
import com.jparams.verifier.tostring.error.VerificationError;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldValueVerificationError
implements VerificationError {
    private final List<FieldValue> fieldValues;

    public FieldValueVerificationError(List<FieldValue> fieldValues) {
        this.fieldValues = fieldValues;
    }

    @Override
    public List<String> getMessages() {
        return Stream.of(this.getExpectedFieldsErrorMessage(), this.getUnexpectedFieldsErrorMessage()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getExpectedFieldsErrorMessage() {
        List errorList = this.fieldValues.stream().filter(fieldValue -> fieldValue.getErrorType() == FieldValue.ErrorType.EXPECTED).map(fieldValue -> String.format("  - %s: %s", fieldValue.getFieldName(), fieldValue.getValue())).collect(Collectors.toList());
        if (errorList.isEmpty()) {
            return null;
        }
        return "contain fields with values:\n" + String.join((CharSequence)"\n", errorList);
    }

    private String getUnexpectedFieldsErrorMessage() {
        List fields = this.fieldValues.stream().filter(fieldValue -> fieldValue.getErrorType() == FieldValue.ErrorType.UNEXPECTED).map(FieldValue::getFieldName).collect(Collectors.toList());
        if (fields.isEmpty()) {
            return null;
        }
        return "not contain field" + (fields.size() == 1 ? "" : "s") + ": " + String.join((CharSequence)", ", fields);
    }
}

