package com.jsftoolkit.base;

import java.io.IOException;
import java.util.Set;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import com.jsftoolkit.base.renderer.HtmlRenderer;

/**
 * 
 * Interface for components (and renderers) that need to write something inside
 * of the head element, e.g. a script or stylesheet include, or an
 * initialization script.
 * 
 * @author noah
 * 
 */
public interface HeadInsert {

	/**
	 * Gives the component a chance to write things into head. See
	 * {@link HtmlRenderer#encodeHead(FacesContext, UIComponent, Set)} for
	 * an example.
	 * 
	 * @param context
	 * @param component
	 * @param resourceIds
	 *            ids of resources already included in the page. This is
	 *            important for Ajax requests because Shale Remoting will not be
	 *            aware of what is already loaded in the page.
	 * @throws IOException
	 */
	void encodeHead(FacesContext context, UIComponent component,
			Set<String> resourceIds) throws IOException;
}
