package com.jsftoolkit.base;

import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.component.UIData;

/**
 * Interface for components that do iteration in JSF, but might not be able to
 * extends {@link UIData}. Each method is expected to do just what it would in
 * UIData. Iteration starts at the index returned by {@link #getFirst()} and
 * ends after {@link #getRows()} have been processed or
 * {@link #isRowAvailable()} returns false.
 * 
 * @author noah
 * 
 */
public interface JsfIterator {

	int getRowIndex();

	int getFirst();

	int getRows();

	void setRowIndex(int rowIndex);

	boolean isRowAvailable();

	Map<String, UIComponent> getFacets();

	List<UIComponent> getChildren();

}
