package com.jsftoolkit.base;

import java.lang.reflect.Modifier;

import javax.faces.webapp.UIComponentELTag;

import com.jsftoolkit.base.renderer.HtmlRenderer;

/**
 * Describes a {@link PassThroughTag}, which is a base {@link UIComponentELTag}
 * for components that pass through a lot of HTML attributes.
 * 
 * @author noah
 * 
 */
public class PassThroughTagSpec {

	/**
	 * @deprecated this constant should not be referenced directly.
	 */
	public static final String[] RENDER_ATTRIBS = HtmlRenderer.PASS_THROUGH
			.toArray(new String[HtmlRenderer.PASS_THROUGH.size()]);

	public static final String TAG_PACKAGE = PassThroughTagSpec.class
			.getPackage().getName();

	public static final String TAG_CLASS_NAME = "PassThroughTag";

	public static final Class<? extends TagBase> TAG_SUPER = TagBase.class;

	public static final int TAG_MODIFIERS = Modifier.PUBLIC | Modifier.ABSTRACT;

}
