package com.jsftoolkit.base;

import com.jsftoolkit.base.ResourceInfo.Type;

/**
 * Constants related to resources.
 * 
 * @author noah
 * 
 */
public class ResourceConstants {

	/**
	 * The managed bean used to filter
	 */
	public static final String RESOURCE_FILTER = "com_jsftoolkit_resourceFilter";

	/**
	 * The default encoding.
	 */
	public static final String RESOURCE_ENCODING = "UTF-8";

	/**
	 * The currently supported DOJO version is 0.4.1, including other versions
	 * will cause conflicts between components.
	 */
	public static final ResourceInfo DOJO_JS = new ResourceInfo(
			"org.dojotoolkit.DOJO_JS", "/scripts/dojo/dojo.js", Type.SCRIPT,
			RESOURCE_ENCODING, null);

	public static final ResourceInfo JSFTK_JS = new ResourceInfo(
				"com.jsftoolkit.JSFTK_JS",
				"/scripts/jsfTk/src/jsfTk.js", Type.SCRIPT,
				RESOURCE_ENCODING, null);

}
