package com.jsftoolkit.base;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentELTag;

/**
 * Base class for {@link UIComponentELTag}s, but will more likely be used
 * statically.
 * 
 * @author noah
 * 
 */
public abstract class TagBase extends UIComponentELTag {

	/**
	 * Set the value expression on the given component. (this should
	 * automatically set the property on the component, setting it via a getter
	 * if necessary).
	 * 
	 * @param component
	 * @param attributeName
	 * @param valueExpression
	 */
	public static void setProperty(UIComponent component,
			String attributeName, ValueExpression valueExpression) {
		component.setValueExpression(attributeName, valueExpression);
	}

}
