package com.jsftoolkit.base.renderer;

import java.util.Set;

import com.jsftoolkit.utils.xmlpull.PullEvent;

/**
 * Signals that some set of attributes should be passed through to the current
 * element.
 * 
 * @see HtmlRenderer
 * 
 * @author noah
 * 
 */
public class PassThrough implements PullEvent {

	public static final int TYPE = 7;

	private final Set<String> allowed;

	/**
	 * 
	 * @param allowed
	 *            the names of component attributes that should be passed
	 *            through to the current element.
	 */
	public PassThrough(final Set<String> allowed) {
		super();
		this.allowed = allowed;
	}

	public Set<String> getAllowed() {
		return allowed;
	}

	public short getType() {
		return TYPE;
	}

}
