package com.jsftoolkit.base.renderer;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

/**
 * {@link RenderCallback} that delegates to a {@link Renderer}.
 * 
 * @author noah
 * 
 */
public class RendererCallbackAdaptor implements RenderCallback {

	private final Renderer renderer;

	public RendererCallbackAdaptor(final Renderer renderer) {
		super();
		this.renderer = renderer;
	}

	public void encodeBegin(FacesContext context, UIComponent component)
			throws IOException {
		renderer.encodeBegin(context, component);
	}

	public void encodeChildren(FacesContext context, UIComponent component)
			throws IOException {
		renderer.encodeChildren(context, component);
	}

	public void encodeEnd(FacesContext context, UIComponent component)
			throws IOException {
		renderer.encodeEnd(context, component);
	}

	public void decode(FacesContext context, UIComponent component) {
		renderer.decode(context, component);
	}

}
