package com.jsftoolkit.base.renderer;

import java.util.List;

import com.jsftoolkit.utils.xmlpull.PullEvent;

/**
 * Signals that an attribute should be rendered that contains 1 or more variable
 * substitutions.
 * 
 * @author noah
 * 
 */
public class VarAttribEvent implements PullEvent {

	public static final short TYPE = 3;

	private final List<String> properties;

	private final List<String> defaultValues;

	private final String pattern;

	private String name;

	public VarAttribEvent(String name, String pattern, List<String> properties,
			List<String> defaultValues) {
		this.name = name;
		this.pattern = pattern;
		this.properties = properties;
		this.defaultValues = defaultValues;
	}

	public List<String> getDefaultValues() {
		return defaultValues;
	}

	public List<String> getProperties() {
		return properties;
	}

	public String getPattern() {
		return pattern;
	}

	public String getName() {
		return name;
	}

	public short getType() {
		return TYPE;
	}
}
