package com.jsftoolkit.base.renderer;

import com.jsftoolkit.utils.xmlpull.PullEvent;

/**
 * Signals that a component property should be output as text.
 * 
 * @author noah
 * 
 */
public class VarTextEvent implements PullEvent {
	public static final int TYPE = 5;

	private final String property;

	private final String defaultValue;

	public VarTextEvent(final String property, final String defaultValue) {
		super();
		this.property = property;
		this.defaultValue = defaultValue;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public String getProperty() {
		return property;
	}

	public short getType() {
		return TYPE;
	}

}
