package com.jsftoolkit.gen.info;

import com.jsftoolkit.utils.Utils;
import com.jsftoolkit.utils.serial.XmlAttribute;

/**
 * Base class for subcomponents of {@link ComponentInfo} that need a reference
 * back to the owning instance.
 * 
 * @author noah
 */
public abstract class ChildInfo extends ClassInfo {
	private ClassInfo component;

	/**
	 * Initializes nothing.
	 */
	public ChildInfo() {
		super();
	}

	/**
	 * Initializes the parent component.
	 * 
	 * @param component
	 */
	public ChildInfo(ClassInfo component) {
		this();
		this.component = component;
	}

	/**
	 * Passes through to
	 * {@link ClassInfo#ClassInfo(String, String, boolean, Class[])}
	 * 
	 * @param _package
	 * @param className
	 * @param _abstract
	 * @param interfaces
	 */
	public ChildInfo(String _package, String className, boolean _abstract,
			Class<?>... interfaces) {
		super(_package, className, _abstract, interfaces);
	}

	/**
	 * 
	 * @return the component we are the child of
	 */
	public ClassInfo getComponent() {
		return component;
	}

	public void setComponent(ClassInfo component) {
		this.component = component;
	}

	/**
	 * @return the set package name, unless it is null, in which case the parent
	 *         package is returned (if it is non-null).
	 */
	@Override
	@XmlAttribute
	public String getPackage() {
		return Utils.getValue(super.getPackage(), component == null ? null
				: component.getPackage());
	}

}
