package com.jsftoolkit.gen.info;

import com.jsftoolkit.utils.serial.XmlAttribute;
import com.jsftoolkit.utils.serial.XmlElement;

/**
 * Describes a String constant that should belong to the generated component.
 * 
 * @author noah
 * 
 */
@XmlElement(tagName = "constant")
public class ConstantInfo {
	private String name;

	private String value;

	/**
	 * Default constructor.
	 */
	public ConstantInfo() {
		super();
	}

	/**
	 * 
	 * @param name
	 *            the constant name, e.g. CONSTANT
	 * @param value
	 *            the value
	 */
	public ConstantInfo(final String name, final String value) {
		this();
		this.name = name;
		this.value = value;
	}

	/**
	 * 
	 * @return name of the constant
	 */
	@XmlAttribute
	public String getName() {
		return name;
	}

	/**
	 * 
	 * @return the value of the constant
	 */
	@XmlAttribute
	public String getValue() {
		return value;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ConstantInfo other = (ConstantInfo) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}
}
