package com.jsftoolkit.gen.info;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.faces.component.UIInput;

import com.jsftoolkit.base.ResourceInfo;
import com.jsftoolkit.utils.Utils;
import com.jsftoolkit.utils.serial.XmlAttribute;
import com.jsftoolkit.utils.serial.XmlCollection;
import com.jsftoolkit.utils.serial.XmlElement;

@XmlElement(tagName = "renderer")
public class RendererInfo extends ChildInfo {

	private Set<ResourceInfo> includes = new LinkedHashSet<ResourceInfo>();

	private String templateEncoding = "UTF-8";

	private String template;

	private Set<String> attribs = new HashSet<String>();

	private String decodeParam;

	private String headTemplate;

	public RendererInfo() {
		super();
	}

	public RendererInfo(String _package, String className,
			String templateEncoding, String template, boolean _abstract,
			String... attribs) {
		super(_package, className, _abstract);
		this.templateEncoding = templateEncoding;
		this.template = template;
		for (String attrib : attribs) {
			this.attribs.add(attrib);
		}
	}

	public RendererInfo(ClassInfo component) {
		super(component);
	}

	@XmlCollection
	public Set<ResourceInfo> getIncludes() {
		return includes;
	}

	public void setIncludes(Set<ResourceInfo> includes) {
		this.includes = includes;
	}

	@XmlAttribute
	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}

	@XmlAttribute
	public String getTemplateEncoding() {
		return templateEncoding;
	}

	public void setTemplateEncoding(String templateEncoding) {
		if (templateEncoding != null) {
			this.templateEncoding = templateEncoding;
		}
	}

	/**
	 * 
	 * @return the location of the head insert template. If one is not specified
	 *         but a template is, the template name is transformed to get the
	 *         head template name. e.g. if the template name is
	 *         '/com/yourcompany/Foo.xhtml', then
	 *         '/com/yourcompany/Foo-head.xhtml' is returned.
	 */
	@XmlAttribute
	public String getHeadTemplate() {
		return headTemplate == null ? getDefaultHeadTemplate() : headTemplate;
	}

	public void setHeadTemplate(String headTemplate) {
		this.headTemplate = headTemplate;
	}

	private String getDefaultHeadTemplate() {
		if (template == null || !template.contains(".")) {
			return null;
		}
		int lastDot = template.lastIndexOf('.');
		assert lastDot >= 0;
		return String.format("%s-head%s", template.substring(0, lastDot),
				template.substring(lastDot));
	}

	@XmlCollection(itemTag = "attrib")
	public Set<String> getAttribs() {
		return attribs;
	}

	public void setAttribs(Set<String> attribs) {
		this.attribs = attribs;
	}

	/**
	 * 
	 * @return the name of the request parameter to decode (i.e. the value of
	 *         the parameter will be passed as the argument to
	 *         {@link UIInput#setSubmittedValue(Object)}). May contain property
	 *         subsititions (e.g. ${id})
	 */
	@XmlAttribute
	public String getDecodeParam() {
		return decodeParam;
	}

	public void setDecodeParam(String decodeParam) {
		this.decodeParam = decodeParam;
	}

	@Override
	@XmlAttribute
	public String getClassName() {
		return Utils.getValue(super.getClassName(),
				getComponent() == null ? null : getDefaultClassName()
						+ nameSuffix());
	}

	@Override
	public String getActualClassName() {
		return super.getActualClassName() == null && getComponent() != null ? getDefaultClassName()
				: super.getActualClassName();
	}

	protected String getDefaultClassName() {
		return "Html" + getComponent().getActualClassName() + "Renderer";
	}

	public void addAttribute(String o) {
		attribs.add(o);
	}

	public void addInclude(ResourceInfo o) {
		includes.add(o);
	}
}
