package com.jsftoolkit.gen.info;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

import javax.faces.webapp.UIComponentELTag;

import com.jsftoolkit.base.TagBase;
import com.jsftoolkit.utils.Utils;
import com.jsftoolkit.utils.serial.XmlAttribute;
import com.jsftoolkit.utils.serial.XmlElement;

/**
 * Describes the tag handler for a component.
 * 
 * @author noah
 * 
 */
@XmlElement(tagName = "tag")
public class TagInfo extends ChildInfo {

	/**
	 * The tag handler is the one place where inheritance is necessary to avoid
	 * duplicating code. A tag handler has to have a get/set pair for each
	 * component attribute. In other words: JSP sucks.
	 */
	private Class<? extends UIComponentELTag> superClass = TagBase.class;

	/**
	 * Default constructor.
	 */
	public TagInfo() {
		super();
	}

	/**
	 * 
	 * @param component
	 *            the component this tag handler is for
	 */
	public TagInfo(ClassInfo component) {
		super(component);
	}

	/**
	 * Convenience constructor. Passes through everything but superClass to
	 * {@link ClassInfo#ClassInfo(String, String, boolean, Class[])}.
	 * 
	 * @param _package
	 * @param className
	 * @param _abstract
	 * @param superClass
	 * @param interfaces
	 */
	public TagInfo(String _package, String className, boolean _abstract,
			Class<? extends UIComponentELTag> superClass,
			Class<?>... interfaces) {
		super(_package, className, _abstract, interfaces);
		setSuperClass(superClass);
	}

	/**
	 * 
	 * @return the class this tag should subclass.
	 */
	@XmlAttribute
	public Class<? extends UIComponentELTag> getSuperClass() {
		return superClass;
	}

	public void setSuperClass(Class<? extends UIComponentELTag> superClass) {
		if (superClass != null) {
			this.superClass = superClass;
		}
	}

	/**
	 * @return the class name of the tag handler. If one has not been set for
	 *         this tag, the component name + 'Tag' is returned.
	 */
	@Override
	public String getClassName() {
		return Utils.getValue(super.getClassName(),
				getComponent() == null ? null : getComponent()
						.getActualClassName()
						+ "Tag" + nameSuffix());
	}

	/**
	 * Convenience getter.
	 * 
	 * @return the property descriptors for the tag handler superclass
	 * @throws IntrospectionException
	 */
	public PropertyDescriptor[] getPropertyDescriptors()
			throws IntrospectionException {
		return Introspector.getBeanInfo(superClass, UIComponentELTag.class)
				.getPropertyDescriptors();
	}

}
