package com.jsftoolkit.test;

import java.io.IOException;
import java.io.StringWriter;

import javax.faces.component.UIComponent;

import org.apache.shale.test.base.AbstractJsfTestCase;
import org.apache.shale.test.mock.MockResponseWriter;
import org.xml.sax.SAXException;

import com.jsftoolkit.base.renderer.HtmlRenderer;

public abstract class AbstractHtmlRendererTest extends AbstractJsfTestCase {

	protected HtmlRenderer renderer;

	private StringWriter writer;

	public AbstractHtmlRendererTest(String template) throws IOException,
			SAXException {
		this(new HtmlRenderer(template) {
		});
	}

	protected AbstractHtmlRendererTest(HtmlRenderer renderer) {
		super("HtmlRendererTest");
		this.renderer = renderer;
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		writer = new StringWriter();
		facesContext.setResponseWriter(new MockResponseWriter(writer,
				"application/xhtml+xml", "US-ASCII"));
	}

	protected void checkOutput(UIComponent component, String expected)
			throws IOException {
		renderer.encodeBegin(facesContext, component);
		renderer.encodeChildren(facesContext, component);
		renderer.encodeEnd(facesContext, component);
		facesContext.getResponseWriter().close();
		assertEquals(expected, writer.toString());
	}

}