package com.jsftoolkit.test;

import javax.faces.component.UIComponent;

import org.apache.shale.test.base.AbstractJsfTestCase;

public abstract class AbstractUIComponentTest<C extends UIComponent> extends
		AbstractJsfTestCase {
	private Class<C> componentClass;

	protected C component;

	public AbstractUIComponentTest(Class<C> componentClass) {
		super("UIComponent Test");
		this.componentClass = componentClass;
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		component = componentClass.newInstance();
	}

	/**
	 * Only checks that save and restore do not throw exceptions
	 * 
	 * @throws Exception
	 */
	public void testSaveRestore() throws Exception {
		component.restoreState(facesContext, component.saveState(facesContext));
	}
}
