package com.jsftoolkit.test;

import java.io.IOException;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

public class MockUIComponent extends UIComponentBase {

	private Renderer renderer;

	public MockUIComponent() {
		super();
	}

	public MockUIComponent(Renderer renderer) {
		this();
		this.renderer = renderer;
	}

	@Override
	public void encodeBegin(FacesContext context) throws IOException {
		if (renderer == null) {
			super.encodeBegin(context);
		} else {
			renderer.encodeBegin(context, this);
		}
	}

	@Override
	public void encodeChildren(FacesContext context) throws IOException {
		if (renderer == null) {
			super.encodeChildren(context);
		} else {
			renderer.encodeChildren(context, this);
		}
	}

	@Override
	public void encodeEnd(FacesContext context) throws IOException {
		if (renderer == null) {
			super.encodeEnd(context);
		} else {
			renderer.encodeEnd(context, this);
		}
	}

	@Override
	public String getFamily() {
		return null;
	}

	public void set(String property, Object value) {
		getAttributes().put(property, value);
	}

}
