package com.jsftoolkit.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * {@link OutputStream} implementation that, like {@link FilterOutputStream},
 * delegates to another {@link OutputStream}, but retrieves the stream via an
 * abstract getter ({@link #getStream()}), allowing for more flexible
 * behavior.
 * <p>
 * In other words, the responsibility for storing the {@link OutputStream} is
 * delegated to subclasses.
 * 
 * @author noah
 * 
 */
public abstract class DelegatingOutputStream extends OutputStream {

	@Override
	public void write(int b) throws IOException {
		getStream().write(b);
	}

	@Override
	public void close() throws IOException {
		getStream().close();
	}

	@Override
	public void flush() throws IOException {
		getStream().flush();
	}

	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		getStream().write(b, off, len);
	}

	@Override
	public void write(byte[] b) throws IOException {
		getStream().write(b);
	}

	protected abstract OutputStream getStream() throws IOException;

}
