package com.jsftoolkit.utils;

import java.io.IOException;
import java.io.Reader;

/**
 * Reader wrapper that keeps track of whether the end of stream has been
 * reached.
 * 
 * @author noah
 * 
 */
public class IsFinishedReader extends Reader {

	private final Reader reader;

	private boolean finished;

	public IsFinishedReader(Reader reader) {
		super();
		this.reader = reader;
	}

	@Override
	public void close() throws IOException {
		finished = true;
		reader.close();
	}

	@Override
	public int read() throws IOException {
		return check(reader.read());
	}

	@Override
	public int read(char[] cbuf) throws IOException {
		return check(reader.read(cbuf));
	}

	@Override
	public int read(char[] cbuf, int off, int len) throws IOException {
		return check(reader.read(cbuf, off, len));
	}

	private int check(int read) {
		finished = (read == -1);
		return read;
	}

	/**
	 * 
	 * @return true if the EOS was reached or the stream has been closed.
	 */
	public boolean isFinished() {
		return finished;
	}
}
