package com.jsftoolkit.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

/**
 * {@link PrintStream} where the close method does not close the stream.
 * Intended for wrapping output streams passed to APIs that may automatically
 * close the stream.
 * 
 * @author noah
 * 
 */
public class OpenPrintStream extends PrintStream {

	public OpenPrintStream(File file, String csn) throws FileNotFoundException,
			UnsupportedEncodingException {
		super(file, csn);
	}

	public OpenPrintStream(File file) throws FileNotFoundException {
		super(file);
	}

	public OpenPrintStream(OutputStream out, boolean autoFlush, String encoding)
			throws UnsupportedEncodingException {
		super(out, autoFlush, encoding);
	}

	public OpenPrintStream(OutputStream out, boolean autoFlush) {
		super(out, autoFlush);
	}

	public OpenPrintStream(OutputStream out) {
		super(out);
	}

	public OpenPrintStream(String fileName, String csn)
			throws FileNotFoundException, UnsupportedEncodingException {
		super(fileName, csn);
	}

	public OpenPrintStream(String fileName) throws FileNotFoundException {
		super(fileName);
	}

	/**
	 * Flushes, but does not close the stream.
	 */
	@Override
	public void close() {
		flush();
	}

	/**
	 * Closes the stream.
	 */
	public void reallyClose() {
		super.close();
	}
}
