package com.jsftoolkit.utils;

import java.io.IOException;
import java.util.Stack;

import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/**
 * Records all the tags open by the wrapped {@link ResponseWriter}.
 * {@link #closeAllOpen()} will close any tags that have not been closed.
 * 
 * @author noah
 * 
 */
public class RecordTagsWriter extends ResponseWriterWrapper {

	private final ResponseWriter wrapped;

	private Stack<String> open = new Stack<String>();

	public RecordTagsWriter(ResponseWriter wrapped) {
		super();
		this.wrapped = wrapped;
	}

	public ResponseWriter getWrapped() {
		return wrapped;
	}

	@Override
	public void startElement(String name, UIComponent component)
			throws IOException {
		super.startElement(name, component);
		open.push(name);
	}

	@Override
	public void endElement(String name) throws IOException {
		super.endElement(name);
		open.pop();
	}

	/**
	 * Closes any tags that have not been closed that were opened by this
	 * writer.
	 * 
	 * @throws IOException
	 */
	public void closeAllOpen() throws IOException {
		while (!open.isEmpty()) {
			wrapped.endElement(open.pop());
		}
	}
}
