package com.jsftoolkit.utils;

import java.io.IOException;

public interface ResourceFilter {

	/**
	 * Key for the parameter that specifies the classpath resource to load.
	 */
	public static final String RESOURCE_KEY = "resource";

	/**
	 * Key for the parameter that specifies the encoding of the resource.
	 */
	public static final String CHARSET_KEY = "encoding";

	/**
	 * Key for the parameter that specifies the type of the resource. e.g.
	 * 'text/css'
	 */
	public static final String CONTENT_TYPE_KEY = "contentType";

	/**
	 * Checks the response for {@link #RESOURCE_KEY}, {@link #CHARSET_KEY} and
	 * {@link #CONTENT_TYPE_KEY}.
	 * 
	 * @throws IOException
	 */
	void writeFilteredResource() throws IOException;

}