package com.jsftoolkit.utils.serial;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * Converts objects of a particular class to DOM Nodes.
 * 
 * @author noah
 * 
 * @param <T>
 */
public interface DomSerializer<T> {
	/**
	 * Implementations only need to convert the immediate object, obj. Nested
	 * elements may be passed on to manager.
	 * 
	 * @param obj
	 * @param doc
	 *            the document the new node should belong to
	 * @param manager
	 * @return
	 */
	Node toDom(T obj, Document doc, DomSerializerManager manager);
}
