package com.jsftoolkit.utils.serial;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * 
 * @author noah
 * 
 */
public interface DomSerializerManager extends Serializer<Object> {

	/**
	 * Called by {@link DomSerializer}s when they wish to delegate processing
	 * of a branch to another serializer. The manager is expected to pick
	 * another serializer to continue processing.
	 * 
	 * @param obj
	 *            the object to convert
	 * @param doc
	 *            the document
	 * @return the node
	 */
	Node nextToDom(Object obj, Document doc);

	/**
	 * For converting attributes to string values.
	 */
	String serialize(Object obj);
}