package com.jsftoolkit.utils.serial;

/**
 * Complement to Commons {@link org.apache.commons.beanutils.Converter}.
 * Implementations convert objects to strings that a Commons Converter can turn
 * back into the object.
 * 
 * @author noah
 * 
 * @param <T>
 */
public interface Serializer<T> {

	/**
	 * 
	 * @param obj
	 *            a non-null instance of class T
	 * @return a CharSequence for the given object.
	 * @throws NullPointerException
	 *             if obj is null
	 */
	String serialize(T obj) throws NullPointerException;

}