package com.jsftoolkit.utils.serial;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Used to annotate the getters for properties that should be converted to an
 * XML attribute.
 * 
 * @author noah
 * 
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface XmlAttribute {
	/**
	 * 
	 * @return the name of the attribute, or "" if the name should be determined
	 *         via introspection.
	 */
	String name() default "";
}
