package com.jsftoolkit.utils.serial;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;

/**
 * Annotation for marking the getter of properties that are {@link Collection}s
 * or {@link Map}. A Map marked with this annotation will have only its values
 * serialized.
 * 
 * @author noah
 * 
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface XmlCollection {
	/**
	 * 
	 * @return the name of the tag that should enclose the serialized form of
	 *         each item in the collection, or "" if it should be added
	 *         directly.
	 */
	String itemTag() default "";
}
