if( typeof JsfTk == "undefined") {

/**
 * Declare class/namespace JsfTk.
 */
function JsfTk() { }

JsfTk.HtmlScriptsId = 'Not Set';
JsfTk.HtmlScriptsResourceIds = '';

/**
 * Combines the user defined properties of all the arguments together
 * into a new object, which is returned.
 */
JsfTk.shallowCopy = function() {
   var i;
   var srcObj;
   var destObj = {};
   if(arguments.length > 0 ) {
      for( i = 0; i < arguments.length; i++ ) {
         srcObj = arguments[i];
         if( srcObj ) { // make sure it's not null         
            for( var prop in srcObj ) {
               destObj[prop] = srcObj[prop];
            }
         }
      }
   }
   return destObj;
};

/**
 * Moves all of src's children in to dest.
 */
JsfTk.moveChildren = function(src,dest) {   
   while(src.firstChild) {
      dest.appendChild(src.removeChild(src.firstChild));
   }
   return dest;
};

/**
 * Copies all src's attributes to dest.
 */
JsfTk.copyAttributes = function(src,dest) {
   var name;
   var value;
   for(var i = 0; i < src.attributes.length; i++ ) {
      name = src.attributes[i].name;
      value = src.attributes[i].value;
      dest.attributes[name] = value;
      dojo.debug(name+' is ' + dest.attributes[name]);
   }
   return dest;
};

/**
 * Moves all src's children to dest and copies it's attributes.
 * If dest is not specified, a div element will be created.
 */
JsfTk.transfer = function(src,dest) {
   dest = dest || document.createElement("div");      
   this.moveChildren(src,dest);
   return this.copyAttributes(src,dest);
};

/**
 * Finds the first element with the given id, in a search rooted at parent.
 * The whole document is searched if parent is null/undefined.
 */
 /* public static */
JsfTk.byId = function (id, parent){
        var c;
        var recurse;
        if (typeof id == 'string') {
            if( parent ) {
              for( c in parent.childNodes ) {
                recurse = null;
                    if(c.id == id) {
                       return c;
                    } else {
                       recurse = byId(id,c);
                       if(recurse) {
                          return recurse;
                       }
                    }
              }
              return null;
            }
         return document.getElementById(id);
      }
      return id;
    };
    
  /* public static */
JsfTk.byIds = function (){
      if (arguments.length === 1) {     
         return arguments[0];
      }
      var array = [];
      for (var i = 0; i < arguments.length; i++) {
         array.push(byId(arguments[i]));
      }
      return array;
   };

/**
 * Returns the id of the element. It it is a string
 * it is returned verbatim.
 */
  /* public static */
JsfTk.toId = function (elem) {
      if( elem ) {      
           if (typeof elem == 'string') {
            return elem;
           }      
           return elem.id;
        }
        return null;
   };
   
/**
 * Returns an array of the ids of the elements passed in. 
 * Any string elements are returned unaltered (since they 
 * are probably ids)
 */   
  /* public static */
JsfTk.toIds = function () {
      var array = [];
      if(arguments.length === 1 && arguments[0] && arguments[0].constructor == Array) {
         args = arguments[0];
      }  else {
         args = arguments;
      }        
      for( var i = 0; i < args.length; i++ ) {
         if( args[i] ) {
            array.push( this.toId(args[i]) );
         }
      }
      return array;
   };

/** 
 * Finds all the child elements with the given tag name. If
 * parent is not specified, searches the whole document.
 */
  /* public static */
JsfTk.byTag = function (tag, parent){
         if(parent) {           
           return JsfTk.byId(parent).getElementsByTagName(tag);
         }
         return document.getElementsByTagName(tag);
    };
    
/**
 * Concatenates the values of property on each item, with token as 
 * the delimeter. e.g. 
 * function Foo(foo) {
 *   this.foo = foo;
 * }
 *
 * join([new Foo('bar'),new Foo('baz')],';','foo') == 'bar;baz'
 *
 * Additional, items that do no have the given property are ignored:
 *
 * function Bar(bar) {
 *   this.bar = bar;
 * } 
 * 
 * join([new Foo('bar'),new Foo('baz'),new Bar('foo')],';','foo') == 'bar;baz'
 *
 */
/* public static */
JsfTk.join = function(items,token,property) {
   if(items.length < 1) {
       return "";
   }
   
   var s = "";
   var p;
   for(var i = 0; i < items.length; i++ ) {
       p = items[i][property];
       if(p) {
        s += p;
       }
       if(s.length > 0 && items[i + 1] && items[i+1][property]) {
         s += token;
       }
   }
   
   return s;
};

/**
 * Return true if foo is null, the empty string,
 * an empty array, or an array of length 1 containing the empty
 * string or null.
 */
JsfTk.isEmpty = function(foo) {
      return foo === null || foo === "" || foo === {} || 
         (typeof foo == "array" && foo.length === 1 && 
            (foo === null || foo[0] === ""));
   };

/**
 * componentId - the command component to invoke (or it's id).
 * inputIds - array of the ids of the input elements to submit
 * refreshIds - the components to refresh
 * replaceCallback - the function to call with the returned markup 
 *    (as well as the id of the component that rendered that markup)
 *    i.e. function(id,markup) { ... }
 */
JsfTk.ajaxSubmit = function( component, inputIds, refreshIds, replaceCallback ) {      
      if( typeof DynaFaces != "undefined" ) {
         if( !replaceCallback ) {
            replaceCallback = this.safeReplace;
         }
         // make sure we have ids (instead of elements)
         inputIds = this.toIds(inputIds);
         refreshIds = this.toIds(refreshIds);
         // make sure we have the actual component
         component = $(component);
         // need to refresh and submit the action component
         refreshIds = refreshIds.concat( component.id, JsfTk.HtmlScriptsId );
         inputIds = inputIds.concat( component.id );
         DynaFaces.fireAjaxTransaction( component, { 
              render: refreshIds.join(','),
              inputs: inputIds.join(','),
              // add the already rendered resources as a request parameter
              postBody: JsfTk.HtmlScriptsId + '=' + JsfTk.HtmlScriptsResourceIds,              
              replaceElement: replaceCallback
         } );
      }
   };

// XXX if a component renders multiple top level elements, each element's id
// needs to be removed somehow
JsfTk.safeReplace = function(id,markup) {
      var str = markup.stripScripts();
      if( str.strip().length !== 0 ) {
         if (-1 === id.indexOf(DynaFaces.gViewRoot)) {
           var d = DynaFaces.$(id);
           if(!d) {
             alert('Could not find '+id);
           }
           var parent = d.parentNode;
           var temp = document.createElement("div");
           temp.id = d.id;
           temp.innerHTML = str;
           
           // replace the element with all of temp's children 
           // (might be extra text nodes or something)
           var last = parent.replaceChild(temp.lastChild, d);
           for(var i = 1; i < temp.childNodes.length; i++) {
              parent.insertBefore( temp.childNodes[i], last );
           }
         } else {         
            DynaFaces.replace(id,str);
         }      
      }
   };

} // end if( typeof ...