/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.julienviet.rxjava.childprocess;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.Handler;

/**
 * The output of a process:  a stream of .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link com.julienviet.childprocess.StreamOutput original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(com.julienviet.childprocess.StreamOutput.class)
public class StreamOutput implements io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StreamOutput that = (StreamOutput) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<StreamOutput> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new StreamOutput((com.julienviet.childprocess.StreamOutput) obj),
    StreamOutput::getDelegate
  );

  private final com.julienviet.childprocess.StreamOutput delegate;
  
  public StreamOutput(com.julienviet.childprocess.StreamOutput delegate) {
    this.delegate = delegate;
  }

  public com.julienviet.childprocess.StreamOutput getDelegate() {
    return delegate;
  }

  private io.vertx.rx.java.WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized io.vertx.rx.java.WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = io.vertx.rx.java.RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  public void end(io.vertx.rxjava.core.buffer.Buffer t) { 
    delegate.end(t.getDelegate());
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public com.julienviet.rxjava.childprocess.StreamOutput exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public com.julienviet.rxjava.childprocess.StreamOutput write(io.vertx.rxjava.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  public com.julienviet.rxjava.childprocess.StreamOutput setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public com.julienviet.rxjava.childprocess.StreamOutput drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Calls {code close()}.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Close the stream.
   */
  public void close() { 
    delegate.close();
  }


  public static  StreamOutput newInstance(com.julienviet.childprocess.StreamOutput arg) {
    return arg != null ? new StreamOutput(arg) : null;
  }
}
